/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.preprocess;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsHashSet;
import com.helger.collection.commons.ICommonsSet;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class PreprocessorIDPool {
    public static final String DEFAULT_SEPARATOR = "";
    private static final Logger LOGGER = LoggerFactory.getLogger(PreprocessorIDPool.class);
    private static String s_sDefaultSeparator = "";
    private final ICommonsSet<String> m_aUsedIDs = new CommonsHashSet();

    @Nonnull
    public static String getDefaultSeparator() {
        return s_sDefaultSeparator;
    }

    public static void setDefaultSeparator(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"separator");
        s_sDefaultSeparator = string;
    }

    @Nonnull
    public String getSeparator() {
        return PreprocessorIDPool.getDefaultSeparator();
    }

    @Nullable
    public String getUniqueID(@Nullable String string) {
        if (string == null) {
            return null;
        }
        if (this.m_aUsedIDs.add((Object)string)) {
            return string;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("The ID '" + string + "' was already used in the current Schematron - creating a unique version");
        }
        String string2 = string + this.getSeparator();
        int n = 0;
        String string3 = string2 + n;
        while (true) {
            if (this.m_aUsedIDs.add((Object)string3)) {
                LOGGER.warn("The ID '" + string + "' was already used in the current Schematron and replaced with '" + string3 + "'");
                return string3;
            }
            string3 = string2 + ++n;
        }
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("usedIDs", this.m_aUsedIDs).getToString();
    }
}

