/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.xpath;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionException;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.JPConverter;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XPathFunctionFromUserFunction
implements XPathFunction {
    private static final Logger LOGGER = LoggerFactory.getLogger(XPathFunctionFromUserFunction.class);
    private final Configuration m_aConfiguration;
    private final Controller m_aXQController;
    private final UserFunction m_aUserFunc;

    public XPathFunctionFromUserFunction(@Nonnull Configuration configuration, @Nonnull Controller controller, @Nonnull UserFunction userFunction) {
        this.m_aConfiguration = (Configuration)ValueEnforcer.notNull((Object)configuration, (String)"Configuration");
        this.m_aUserFunc = (UserFunction)ValueEnforcer.notNull((Object)userFunction, (String)"UserFunc");
        this.m_aXQController = (Controller)ValueEnforcer.notNull((Object)controller, (String)"XQController");
    }

    @Nonnull
    public UserFunction getUserFunction() {
        return this.m_aUserFunc;
    }

    @Nonnull
    public StructuredQName getFunctionName() {
        return this.m_aUserFunc.getFunctionName();
    }

    @Override
    @Nullable
    public Object evaluate(@Nonnull List<?> list) throws XPathFunctionException {
        LOGGER.info("Evaluating user function '" + String.valueOf(this.getFunctionName()) + "' with " + list.size() + " parameter(s)");
        try {
            Sequence[] sequenceArray = new Sequence[list.size()];
            if (!list.isEmpty()) {
                XPathContextMajor xPathContextMajor = this.m_aXQController.newXPathContext();
                int n = 0;
                for (Object obj : list) {
                    JPConverter jPConverter = JPConverter.allocate(obj.getClass(), null, (Configuration)this.m_aConfiguration);
                    sequenceArray[n] = jPConverter.convert(obj, (XPathContext)xPathContextMajor);
                    ++n;
                }
            }
            return this.m_aUserFunc.call(sequenceArray, this.m_aXQController);
        }
        catch (Exception exception) {
            throw new XPathFunctionException(exception);
        }
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Configuration", (Object)this.m_aConfiguration).append("XQController", (Object)this.m_aXQController).append("UserFunc", (Object)this.m_aUserFunc).getToString();
    }
}

