/*
 * Decompiled with CFR 0.152.
 */
package com.helger.httpclient;

import com.helger.annotation.Nonempty;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.url.IURLDownloader;
import com.helger.httpclient.HttpClientFactory;
import com.helger.httpclient.HttpClientManager;
import com.helger.httpclient.HttpClientSettings;
import com.helger.httpclient.response.ResponseHandlerByteArray;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUrlDownloader
implements IURLDownloader {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClientUrlDownloader.class);
    private final HttpClientFactory m_aHCF;

    public HttpClientUrlDownloader(@Nonnull HttpClientSettings httpClientSettings) {
        this(new HttpClientFactory(httpClientSettings));
    }

    public HttpClientUrlDownloader(@Nonnull HttpClientFactory httpClientFactory) {
        ValueEnforcer.notNull((Object)httpClientFactory, (String)"HttpClientFactory");
        this.m_aHCF = httpClientFactory;
    }

    @Nullable
    public byte[] downloadURL(@Nonnull @Nonempty String string) throws Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Trying to download via HttpClient from '" + string + "'");
        }
        try {
            HttpClientManager httpClientManager = new HttpClientManager(this.m_aHCF);
            try {
                HttpGet httpGet = new HttpGet(string);
                byte[] byArray = httpClientManager.execute((HttpUriRequest)httpGet, new ResponseHandlerByteArray());
                httpClientManager.close();
                return byArray;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        httpClientManager.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    LOGGER.error("Failed to download from '" + string + "': " + exception.getClass().getName() + " - " + exception.getMessage());
                    throw exception;
                }
            }
        }
        finally {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Finished downloading via HttpClient from '" + string + "'");
            }
        }
    }
}

