/*
 * Decompiled with CFR 0.152.
 */
package com.helger.httpclient;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.clone.ICloneable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsLinkedHashSet;
import com.helger.collection.commons.ICommonsOrderedSet;
import com.helger.httpclient.IHttpProxySettings;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.core5.http.HttpHost;

@NotThreadSafe
public class HttpProxySettings
implements IHttpProxySettings,
ICloneable<HttpProxySettings> {
    private HttpHost m_aProxyHost;
    private Credentials m_aProxyCredentials;
    private final ICommonsOrderedSet<String> m_aNonProxyHosts = new CommonsLinkedHashSet();

    public HttpProxySettings() {
    }

    public HttpProxySettings(@Nonnull IHttpProxySettings iHttpProxySettings) {
        this.setAllFrom(iHttpProxySettings);
    }

    @Nonnull
    public final HttpProxySettings setAllFrom(@Nonnull IHttpProxySettings iHttpProxySettings) {
        ValueEnforcer.notNull((Object)iHttpProxySettings, (String)"Source");
        this.setProxyHost(iHttpProxySettings.getProxyHost());
        this.setProxyCredentials(iHttpProxySettings.getProxyCredentials());
        this.nonProxyHosts().setAll(iHttpProxySettings.nonProxyHosts());
        return this;
    }

    @Override
    @Nullable
    public final HttpHost getProxyHost() {
        return this.m_aProxyHost;
    }

    @Nonnull
    public final HttpProxySettings setProxyHost(@Nullable HttpHost httpHost) {
        this.m_aProxyHost = httpHost;
        return this;
    }

    @Override
    @Nullable
    public final Credentials getProxyCredentials() {
        return this.m_aProxyCredentials;
    }

    @Nonnull
    public final HttpProxySettings setProxyCredentials(@Nullable Credentials credentials) {
        this.m_aProxyCredentials = credentials;
        return this;
    }

    @Nonnull
    @ReturnsMutableObject
    public final ICommonsOrderedSet<String> nonProxyHosts() {
        return this.m_aNonProxyHosts;
    }

    @Nonnull
    public final HttpProxySettings addNonProxyHostsFromPipeString(@Nullable String string2) {
        if (StringHelper.isNotEmpty((String)string2)) {
            StringHelper.explode((char)'|', (String)string2, string -> {
                String string2 = string.trim();
                if (StringHelper.isNotEmpty((String)string2)) {
                    this.m_aNonProxyHosts.add((Object)string2);
                }
            });
        }
        return this;
    }

    @Nonnull
    public final HttpProxySettings setNonProxyHostsFromPipeString(@Nullable String string) {
        this.m_aNonProxyHosts.clear();
        return this.addNonProxyHostsFromPipeString(string);
    }

    @Nonnull
    @ReturnsMutableCopy
    public HttpProxySettings getClone() {
        return new HttpProxySettings(this);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("ProxyHost", (Object)this.m_aProxyHost).append("ProxyCredentials", (Object)this.m_aProxyCredentials).append("NonProxyHosts", this.m_aNonProxyHosts).getToString();
    }
}

