/*
 * Decompiled with CFR 0.152.
 */
package com.helger.httpclient.response;

import com.helger.httpclient.response.ExtendedHttpResponseException;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.message.StatusLine;

public class ResponseHandlerHttpEntity
implements HttpClientResponseHandler<HttpEntity> {
    public static final ResponseHandlerHttpEntity INSTANCE = new ResponseHandlerHttpEntity();

    protected ResponseHandlerHttpEntity() {
    }

    @Nullable
    public HttpEntity handleResponse(@Nonnull ClassicHttpResponse classicHttpResponse) throws IOException {
        StatusLine statusLine = new StatusLine((HttpResponse)classicHttpResponse);
        HttpEntity httpEntity = classicHttpResponse.getEntity();
        if (statusLine.getStatusCode() >= 300) {
            throw ExtendedHttpResponseException.create(statusLine, (HttpResponse)classicHttpResponse, httpEntity);
        }
        return httpEntity;
    }
}

