/*
 * Decompiled with CFR 0.152.
 */
package com.helger.mail.datasource;

import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.array.ArrayHelper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.io.nonblocking.NonBlockingByteArrayInputStream;
import com.helger.base.io.nonblocking.NonBlockingByteArrayOutputStream;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.mail.datasource.IExtendedDataSource;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;

public class ByteArrayDataSource
implements IExtendedDataSource {
    private final String m_sContentType;
    private byte[] m_aBytes;
    private final String m_sName;

    public ByteArrayDataSource(@Nonnull byte[] byArray, @Nullable String string, @Nullable String string2) {
        ValueEnforcer.notNull((Object)byArray, (String)"Bytes");
        this.m_aBytes = byArray;
        this.m_sContentType = string == null ? DEFAULT_CONTENT_TYPE.getAsString() : string;
        this.m_sName = string2;
    }

    @Nonnull
    @ReturnsMutableObject
    public byte[] directGetBytes() {
        return this.m_aBytes;
    }

    @Nonnull
    public NonBlockingByteArrayInputStream getInputStream() {
        return new NonBlockingByteArrayInputStream(this.m_aBytes);
    }

    @Nonnull
    public NonBlockingByteArrayOutputStream getOutputStream() throws IOException {
        return new WrappedOutputStream();
    }

    @Nonnull
    public String getContentType() {
        return this.m_sContentType;
    }

    @Nullable
    public String getName() {
        return this.m_sName;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("byte#", ArrayHelper.getSize((byte[])this.m_aBytes)).append("Name", (Object)this.m_sName).append("ContentType", (Object)this.m_sContentType).getToString();
    }

    private class WrappedOutputStream
    extends NonBlockingByteArrayOutputStream {
        private WrappedOutputStream() {
        }

        public void close() {
            super.close();
            ByteArrayDataSource.this.m_aBytes = this.toByteArray();
        }
    }
}

