/*
 * Decompiled with CFR 0.152.
 */
package com.helger.servlet;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class ServletContextPathHolder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServletContextPathHolder.class);
    private static final AtomicBoolean SILENT_MODE = new AtomicBoolean(true);
    private static String s_sServletContextPath;
    private static String s_sCustomContextPath;
    private static final ServletContextPathHolder INSTANCE;

    private ServletContextPathHolder() {
    }

    public static boolean isSilentMode() {
        return SILENT_MODE.get();
    }

    public static boolean setSilentMode(boolean bl) {
        return SILENT_MODE.getAndSet(bl);
    }

    public static void setServletContextPath(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"ServletContextPath");
        if (s_sServletContextPath == null) {
            if (!ServletContextPathHolder.isSilentMode()) {
                LOGGER.info("Setting servlet context path to '" + string + "'!");
            }
            s_sServletContextPath = string;
        } else if (!s_sServletContextPath.equals(string)) {
            LOGGER.error("Overwriting servlet context path '" + s_sServletContextPath + "' with '" + string + "'", (Throwable)new IllegalStateException("Just for tracking how this happens"));
            s_sServletContextPath = string;
        }
    }

    public static boolean hasServletContextPath() {
        return s_sCustomContextPath != null;
    }

    @Nullable
    public static String getServletContextPath() {
        return s_sServletContextPath;
    }

    public static void setCustomContextPath(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"CustomContextPath");
        if (s_sCustomContextPath == null) {
            if (!ServletContextPathHolder.isSilentMode()) {
                LOGGER.info("Setting custom servlet context path to '" + string + "'!");
            }
            s_sCustomContextPath = string;
        } else if (!s_sCustomContextPath.equals(string)) {
            LOGGER.error("Overwriting custom servlet context path '" + s_sCustomContextPath + "' with '" + string + "'", (Throwable)new IllegalStateException("Just for tracking how this happens"));
            s_sCustomContextPath = string;
        }
    }

    public static boolean hasCustomContextPath() {
        return s_sCustomContextPath != null;
    }

    @Nullable
    public static String getCustomContextPath() {
        return s_sCustomContextPath;
    }

    public static boolean hasContextPath() {
        return ServletContextPathHolder.hasCustomContextPath() || ServletContextPathHolder.hasServletContextPath();
    }

    @Nullable
    public static String getContextPathOrNull() {
        String string = s_sCustomContextPath;
        if (string == null) {
            string = s_sServletContextPath;
        }
        return string;
    }

    @Nonnull
    public static String getContextPath() {
        String string = ServletContextPathHolder.getContextPathOrNull();
        if (string == null) {
            throw new IllegalStateException("No servlet context path present!");
        }
        return string;
    }

    public static void clearContextPath() {
        if (s_sServletContextPath != null) {
            if (!ServletContextPathHolder.isSilentMode()) {
                LOGGER.info("The servlet context path '" + s_sServletContextPath + "' was cleared!");
            }
            s_sServletContextPath = null;
        }
        if (s_sCustomContextPath != null) {
            if (!ServletContextPathHolder.isSilentMode()) {
                LOGGER.info("The custom servlet context path '" + s_sCustomContextPath + "' was cleared!");
            }
            s_sCustomContextPath = null;
        }
    }

    static {
        INSTANCE = new ServletContextPathHolder();
    }
}

