/*
 * Decompiled with CFR 0.152.
 */
package com.helger.servlet.mock;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.servlet.mock.MockHttpServletResponse;
import jakarta.annotation.Nonnull;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class MockRequestDispatcher
implements RequestDispatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(MockRequestDispatcher.class);
    private final String m_sURL;

    public MockRequestDispatcher(@Nonnull String string) {
        this.m_sURL = (String)ValueEnforcer.notNull((Object)string, (String)"URL");
    }

    public void forward(@Nonnull ServletRequest servletRequest, @Nonnull ServletResponse servletResponse) {
        ValueEnforcer.notNull((Object)servletRequest, (String)"Request");
        ValueEnforcer.notNull((Object)servletResponse, (String)"Response");
        if (servletResponse.isCommitted()) {
            throw new IllegalStateException("Cannot perform forward - response is already committed");
        }
        this.getMockHttpServletResponse(servletResponse).setForwardedUrl(this.m_sURL);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("MockRequestDispatcher: forwarding to URL '" + this.m_sURL + "'");
        }
    }

    public void include(@Nonnull ServletRequest servletRequest, @Nonnull ServletResponse servletResponse) {
        ValueEnforcer.notNull((Object)servletRequest, (String)"Request");
        ValueEnforcer.notNull((Object)servletResponse, (String)"Response");
        this.getMockHttpServletResponse(servletResponse).setIncludedUrl(this.m_sURL);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("MockRequestDispatcher: including URL '" + this.m_sURL + "'");
        }
    }

    @Nonnull
    protected MockHttpServletResponse getMockHttpServletResponse(@Nonnull ServletResponse servletResponse) {
        if (servletResponse instanceof MockHttpServletResponse) {
            return (MockHttpServletResponse)servletResponse;
        }
        if (servletResponse instanceof HttpServletResponseWrapper) {
            return this.getMockHttpServletResponse(((HttpServletResponseWrapper)servletResponse).getResponse());
        }
        throw new IllegalArgumentException("MockRequestDispatcher requires MockHttpServletResponse");
    }
}

