/*
 * Decompiled with CFR 0.152.
 */
package com.helger.servlet.request;

import com.helger.annotation.CheckForSigned;
import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.http.EHttpMethod;
import com.helger.http.EHttpVersion;
import com.helger.http.basicauth.BasicAuthClientCredentials;
import com.helger.http.basicauth.HttpBasicAuth;
import com.helger.http.digestauth.DigestAuthClientCredentials;
import com.helger.http.digestauth.HttpDigestAuth;
import com.helger.http.header.HttpHeaderMap;
import com.helger.http.header.specific.AcceptCharsetHandler;
import com.helger.http.header.specific.AcceptCharsetList;
import com.helger.http.header.specific.AcceptEncodingHandler;
import com.helger.http.header.specific.AcceptEncodingList;
import com.helger.http.header.specific.AcceptLanguageHandler;
import com.helger.http.header.specific.AcceptLanguageList;
import com.helger.http.header.specific.AcceptMimeTypeHandler;
import com.helger.http.header.specific.AcceptMimeTypeList;
import com.helger.network.port.NetworkPortHelper;
import com.helger.network.port.SchemeDefaultPortMapper;
import com.helger.servlet.ServletContextPathHolder;
import com.helger.servlet.ServletHelper;
import com.helger.servlet.request.IRequestParamMap;
import com.helger.servlet.request.RequestParamMap;
import com.helger.url.ISimpleURL;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.security.cert.X509Certificate;
import java.util.Locale;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class RequestHelper {
    public static final String SERVLET_ATTR_SSL_CIPHER_SUITE = "jakarta.servlet.request.cipher_suite";
    public static final String SERVLET_ATTR_SSL_KEY_SIZE = "jakarta.servlet.request.key_size";
    public static final String SERVLET_ATTR_CLIENT_CERTIFICATE = "jakarta.servlet.request.X509Certificate";
    public static final String FORM_DATA = "form-data";
    public static final String ATTACHMENT = "attachment";
    public static final String MULTIPART = "multipart/";
    public static final String MULTIPART_FORM_DATA = "multipart/form-data";
    public static final String MULTIPART_MIXED = "multipart/mixed";
    public static final String DEFAULT_CHECKBOX_HIDDEN_FIELD_PREFIX = "__";
    private static final String SCOPE_ATTR_REQUESTHELP_REQUESTPARAMMAP = "$requesthelp.requestparammap";
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestHelper.class);
    private static final RequestHelper INSTANCE = new RequestHelper();

    private RequestHelper() {
    }

    @Nonnull
    public static String getWithoutSessionID(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"Value");
        int n = string.indexOf(59);
        return n == -1 ? string : string.substring(0, n);
    }

    @Nonnull
    public static ISimpleURL getWithoutSessionID(@Nonnull ISimpleURL iSimpleURL) {
        ValueEnforcer.notNull((Object)iSimpleURL, (String)"URL");
        return iSimpleURL.getWithPath(RequestHelper.getWithoutSessionID(iSimpleURL.getPath()));
    }

    @Nullable
    public static String getSessionID(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"Value");
        int n = string.indexOf(59);
        return n == -1 ? null : string.substring(n + 1);
    }

    @Nullable
    public static String getSessionID(@Nonnull ISimpleURL iSimpleURL) {
        ValueEnforcer.notNull((Object)iSimpleURL, (String)"URL");
        return RequestHelper.getSessionID(iSimpleURL.getPath());
    }

    @Nonnull
    public static String getRequestURIDecoded(@Nonnull HttpServletRequest httpServletRequest) {
        ValueEnforcer.notNull((Object)httpServletRequest, (String)"HttpRequest");
        String string = StringHelper.getNotNull((String)ServletContextPathHolder.getContextPath(), (String)"");
        String string2 = ServletHelper.getRequestServletPath(httpServletRequest);
        String string3 = ServletHelper.getRequestPathInfo(httpServletRequest);
        String string4 = string + string2 + string3;
        if (string4.length() == 0) {
            return string4;
        }
        return RequestHelper.getWithoutSessionID(string4);
    }

    @Nonnull
    public static String getRequestURIEncoded(@Nonnull HttpServletRequest httpServletRequest) {
        String string;
        ValueEnforcer.notNull((Object)httpServletRequest, (String)"HttpRequest");
        String string2 = StringHelper.getNotNull((String)ServletContextPathHolder.getContextPathOrNull(), (String)"");
        String string3 = ServletHelper.getRequestContextPath(httpServletRequest, "");
        String string4 = ServletHelper.getRequestRequestURI(httpServletRequest);
        if (string3.length() > 0 && string4.startsWith(string3)) {
            string4 = string4.substring(string3.length());
        }
        if ((string = string2 + string4).length() == 0) {
            return string;
        }
        return RequestHelper.getWithoutSessionID(string);
    }

    @Nullable
    public static String getPathInfo(@Nonnull HttpServletRequest httpServletRequest) {
        ValueEnforcer.notNull((Object)httpServletRequest, (String)"HttpRequest");
        String string = ServletHelper.getRequestPathInfo(httpServletRequest);
        if (StringHelper.isEmpty((String)string)) {
            return string;
        }
        return RequestHelper.getWithoutSessionID(string);
    }

    @Nonnull
    public static String getPathWithinServletContext(@Nonnull HttpServletRequest httpServletRequest) {
        return RequestHelper.getPathWithinServletContext(httpServletRequest, false);
    }

    @Nonnull
    public static String getPathWithinServletContext(@Nonnull HttpServletRequest httpServletRequest, boolean bl) {
        String string;
        ValueEnforcer.notNull((Object)httpServletRequest, (String)"HttpRequest");
        String string2 = string = bl ? RequestHelper.getRequestURIEncoded(httpServletRequest) : RequestHelper.getRequestURIDecoded(httpServletRequest);
        if (StringHelper.isEmpty((String)string)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Having empty request URI '" + string + "' from request " + String.valueOf(httpServletRequest));
            }
            return "/";
        }
        String string3 = ServletContextPathHolder.getContextPath();
        if (StringHelper.isEmpty((String)string3) || !string.startsWith(string3)) {
            return string;
        }
        String string4 = string.substring(string3.length());
        return string4.length() > 0 ? string4 : "/";
    }

    @Nonnull
    public static String getPathWithinServlet(@Nonnull HttpServletRequest httpServletRequest) {
        return RequestHelper.getPathWithinServlet(httpServletRequest, false);
    }

    @Nonnull
    public static String getPathWithinServlet(@Nonnull HttpServletRequest httpServletRequest, boolean bl) {
        ValueEnforcer.notNull((Object)httpServletRequest, (String)"HttpRequest");
        String string = RequestHelper.getPathWithinServletContext(httpServletRequest, bl);
        String string2 = ServletHelper.getRequestServletPath(httpServletRequest);
        if (string.startsWith(string2)) {
            return string.substring(string2.length());
        }
        return string2;
    }

    @Nonnull
    @Nonempty
    public static StringBuilder getRequestURLDecoded(@Nonnull HttpServletRequest httpServletRequest) {
        ValueEnforcer.notNull((Object)httpServletRequest, (String)"HttpRequest");
        return RequestHelper.getFullServerName(httpServletRequest).append(RequestHelper.getRequestURIDecoded(httpServletRequest));
    }

    @Nonnull
    @Nonempty
    public static StringBuilder getRequestURLEncoded(@Nonnull HttpServletRequest httpServletRequest) {
        ValueEnforcer.notNull((Object)httpServletRequest, (String)"HttpRequest");
        return RequestHelper.getFullServerName(httpServletRequest).append(RequestHelper.getRequestURIEncoded(httpServletRequest));
    }

    @Nonnull
    @Nonempty
    public static String getURLDecoded(@Nonnull HttpServletRequest httpServletRequest) {
        ValueEnforcer.notNull((Object)httpServletRequest, (String)"HttpRequest");
        StringBuilder stringBuilder = RequestHelper.getRequestURLDecoded(httpServletRequest);
        String string = ServletHelper.getRequestQueryString(httpServletRequest);
        if (StringHelper.isNotEmpty((String)string)) {
            stringBuilder.append('?').append(string);
        }
        return stringBuilder.toString();
    }

    @Nonnull
    @Nonempty
    public static String getURLEncoded(@Nonnull HttpServletRequest httpServletRequest) {
        ValueEnforcer.notNull((Object)httpServletRequest, (String)"HttpRequest");
        StringBuilder stringBuilder = RequestHelper.getRequestURLEncoded(httpServletRequest);
        String string = ServletHelper.getRequestQueryString(httpServletRequest);
        if (StringHelper.isNotEmpty((String)string)) {
            stringBuilder.append('?').append(string);
        }
        return stringBuilder.toString();
    }

    @Nonnull
    @Nonempty
    public static String getURIDecoded(@Nonnull HttpServletRequest httpServletRequest) {
        ValueEnforcer.notNull((Object)httpServletRequest, (String)"HttpRequest");
        String string = RequestHelper.getRequestURIDecoded(httpServletRequest);
        String string2 = ServletHelper.getRequestQueryString(httpServletRequest);
        if (StringHelper.isNotEmpty((String)string2)) {
            return string + "?" + string2;
        }
        return string;
    }

    @Nonnull
    @Nonempty
    public static String getURIEncoded(@Nonnull HttpServletRequest httpServletRequest) {
        ValueEnforcer.notNull((Object)httpServletRequest, (String)"HttpRequest");
        String string = RequestHelper.getRequestURIEncoded(httpServletRequest);
        String string2 = ServletHelper.getRequestQueryString(httpServletRequest);
        if (StringHelper.isNotEmpty((String)string2)) {
            return string + "?" + string2;
        }
        return string;
    }

    @CheckForSigned
    public static int getDefaultServerPort(@Nullable String string) {
        return SchemeDefaultPortMapper.getDefaultPort((String)string, (int)-1);
    }

    @CheckForSigned
    public static int getServerPortToUse(@Nonnull String string, @CheckForSigned int n) {
        if (!NetworkPortHelper.isValidPort((int)n)) {
            return RequestHelper.getDefaultServerPort(string);
        }
        return n;
    }

    @Nonnull
    @Nonempty
    public static StringBuilder getFullServerName(@Nonnull HttpServletRequest httpServletRequest) {
        ValueEnforcer.notNull((Object)httpServletRequest, (String)"HttpRequest");
        return RequestHelper.getFullServerName(ServletHelper.getRequestScheme(httpServletRequest), ServletHelper.getRequestServerName(httpServletRequest), ServletHelper.getRequestServerPort(httpServletRequest));
    }

    @Nonnull
    @Nonempty
    public static StringBuilder getFullServerName(@Nullable String string, @Nullable String string2, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        if (StringHelper.isNotEmpty((String)string)) {
            stringBuilder.append(string).append("://");
        }
        if (StringHelper.isNotEmpty((String)string2)) {
            stringBuilder.append(string2);
        }
        if (NetworkPortHelper.isValidPort((int)n) && n != RequestHelper.getDefaultServerPort(string)) {
            stringBuilder.append(':').append(n);
        }
        return stringBuilder;
    }

    @Nonnull
    @Nonempty
    public static String getFullServerNameAndPath(@Nullable String string, @Nullable String string2, int n, @Nullable String string3, @Nullable String string4) {
        StringBuilder stringBuilder = RequestHelper.getFullServerName(string, string2, n);
        if (StringHelper.isNotEmpty((String)string3)) {
            if (!StringHelper.startsWith((CharSequence)string3, (char)'/')) {
                stringBuilder.append('/');
            }
            stringBuilder.append(string3);
        }
        if (StringHelper.isNotEmpty((String)string4)) {
            stringBuilder.append('?').append(string4);
        }
        return stringBuilder.toString();
    }

    @Nullable
    public static String getHttpReferer(@Nonnull HttpServletRequest httpServletRequest) {
        ValueEnforcer.notNull((Object)httpServletRequest, (String)"HttpRequest");
        return ServletHelper.getRequestHeader(httpServletRequest, "Referer");
    }

    @Nullable
    public static EHttpVersion getHttpVersion(@Nonnull HttpServletRequest httpServletRequest) {
        ValueEnforcer.notNull((Object)httpServletRequest, (String)"HttpRequest");
        String string = ServletHelper.getRequestProtocol(httpServletRequest);
        return EHttpVersion.getFromNameOrNull((String)string);
    }

    @Nullable
    public static EHttpMethod getHttpMethod(@Nonnull HttpServletRequest httpServletRequest) {
        return RequestHelper.getHttpMethodOrDefault(httpServletRequest, null);
    }

    @Nullable
    public static EHttpMethod getHttpMethodOrDefault(@Nonnull HttpServletRequest httpServletRequest, @Nullable EHttpMethod eHttpMethod) {
        ValueEnforcer.notNull((Object)httpServletRequest, (String)"HttpRequest");
        String string = ServletHelper.getRequestMethod(httpServletRequest);
        EHttpMethod eHttpMethod2 = EHttpMethod.getFromNameOrNull((String)string);
        if (eHttpMethod2 != null) {
            return eHttpMethod2;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Unknown HTTP request method '" + string + "' used in request " + String.valueOf(httpServletRequest));
        }
        return eHttpMethod;
    }

    public static void forEachRequestHeader(@Nonnull HttpServletRequest httpServletRequest, @Nonnull BiConsumer<String, String> biConsumer) {
        ValueEnforcer.notNull((Object)httpServletRequest, (String)"HttpRequest");
        ValueEnforcer.notNull(biConsumer, (String)"Consumer");
        for (String string : ServletHelper.getRequestHeaderNames(httpServletRequest)) {
            for (String string2 : ServletHelper.getRequestHeaders(httpServletRequest, string)) {
                biConsumer.accept(string, string2);
            }
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public static HttpHeaderMap getRequestHeaderMap(@Nonnull HttpServletRequest httpServletRequest) {
        ValueEnforcer.notNull((Object)httpServletRequest, (String)"HttpRequest");
        HttpHeaderMap httpHeaderMap = new HttpHeaderMap();
        RequestHelper.forEachRequestHeader(httpServletRequest, (arg_0, arg_1) -> ((HttpHeaderMap)httpHeaderMap).addHeader(arg_0, arg_1));
        return httpHeaderMap;
    }

    @Nonnull
    public static IRequestParamMap getRequestParamMap(@Nonnull HttpServletRequest httpServletRequest) {
        ValueEnforcer.notNull((Object)httpServletRequest, (String)"HttpRequest");
        IRequestParamMap iRequestParamMap = (IRequestParamMap)ServletHelper.getRequestAttributeAs((ServletRequest)httpServletRequest, SCOPE_ATTR_REQUESTHELP_REQUESTPARAMMAP);
        if (iRequestParamMap == null) {
            iRequestParamMap = RequestParamMap.createFromRequest(httpServletRequest);
            ServletHelper.setRequestAttribute((ServletRequest)httpServletRequest, SCOPE_ATTR_REQUESTHELP_REQUESTPARAMMAP, iRequestParamMap);
        }
        return iRequestParamMap;
    }

    @CheckForSigned
    public static long getContentLength(@Nonnull HttpServletRequest httpServletRequest) {
        ValueEnforcer.notNull((Object)httpServletRequest, (String)"HttpRequest");
        return ServletHelper.getRequestContentLength(httpServletRequest);
    }

    @Nullable
    private static <T> T _getRequestAttr(@Nonnull HttpServletRequest httpServletRequest, @Nonnull @Nonempty String string, @Nonnull Class<T> clazz) {
        ValueEnforcer.notNull((Object)httpServletRequest, (String)"HttpRequest");
        Object t = ServletHelper.getRequestAttributeAs((ServletRequest)httpServletRequest, string);
        if (t == null) {
            return null;
        }
        if (!clazz.isAssignableFrom(t.getClass())) {
            LOGGER.error("Request attribute " + string + " is not of type " + clazz.getName() + " but of type " + t.getClass().getName());
            return null;
        }
        return clazz.cast(t);
    }

    @Nullable
    public static String getRequestSSLCipherSuite(@Nonnull HttpServletRequest httpServletRequest) {
        return RequestHelper._getRequestAttr(httpServletRequest, SERVLET_ATTR_SSL_CIPHER_SUITE, String.class);
    }

    @Nullable
    public static Integer getRequestSSLKeySize(@Nonnull HttpServletRequest httpServletRequest) {
        return RequestHelper._getRequestAttr(httpServletRequest, SERVLET_ATTR_SSL_KEY_SIZE, Integer.class);
    }

    @Nullable
    public static X509Certificate[] getRequestClientCertificates(@Nonnull HttpServletRequest httpServletRequest) {
        return RequestHelper._getRequestAttr(httpServletRequest, SERVLET_ATTR_CLIENT_CERTIFICATE, X509Certificate[].class);
    }

    public static boolean isMultipartContent(@Nullable String string) {
        return string != null && string.toLowerCase(Locale.US).startsWith(MULTIPART);
    }

    public static boolean isMultipartContent(@Nonnull HttpServletRequest httpServletRequest) {
        if (RequestHelper.getHttpMethod(httpServletRequest) != EHttpMethod.POST) {
            return false;
        }
        return RequestHelper.isMultipartContent(ServletHelper.getRequestContentType(httpServletRequest));
    }

    public static boolean isMultipartFormDataContent(@Nullable String string) {
        return string != null && string.toLowerCase(Locale.US).startsWith(MULTIPART_FORM_DATA);
    }

    public static boolean isMultipartFormDataContent(@Nonnull HttpServletRequest httpServletRequest) {
        if (RequestHelper.getHttpMethod(httpServletRequest) != EHttpMethod.POST) {
            return false;
        }
        return RequestHelper.isMultipartFormDataContent(ServletHelper.getRequestContentType(httpServletRequest));
    }

    @Nonnull
    public static AcceptCharsetList getAcceptCharsets(@Nonnull HttpServletRequest httpServletRequest) {
        AcceptCharsetList acceptCharsetList = (AcceptCharsetList)ServletHelper.getRequestAttributeAs((ServletRequest)httpServletRequest, AcceptCharsetList.class.getName());
        if (acceptCharsetList == null) {
            String string = ServletHelper.getRequestHeader(httpServletRequest, "Accept-Charset");
            acceptCharsetList = AcceptCharsetHandler.getAcceptCharsets((String)string);
            ServletHelper.setRequestAttribute((ServletRequest)httpServletRequest, AcceptCharsetList.class.getName(), acceptCharsetList);
        }
        return acceptCharsetList;
    }

    @Nonnull
    public static AcceptEncodingList getAcceptEncodings(@Nonnull HttpServletRequest httpServletRequest) {
        AcceptEncodingList acceptEncodingList = (AcceptEncodingList)ServletHelper.getRequestAttributeAs((ServletRequest)httpServletRequest, AcceptEncodingList.class.getName());
        if (acceptEncodingList == null) {
            String string = ServletHelper.getRequestHeader(httpServletRequest, "Accept-Encoding");
            acceptEncodingList = AcceptEncodingHandler.getAcceptEncodings((String)string);
            ServletHelper.setRequestAttribute((ServletRequest)httpServletRequest, AcceptEncodingList.class.getName(), acceptEncodingList);
        }
        return acceptEncodingList;
    }

    @Nonnull
    public static AcceptLanguageList getAcceptLanguages(@Nonnull HttpServletRequest httpServletRequest) {
        AcceptLanguageList acceptLanguageList = (AcceptLanguageList)ServletHelper.getRequestAttributeAs((ServletRequest)httpServletRequest, AcceptLanguageList.class.getName());
        if (acceptLanguageList == null) {
            String string = ServletHelper.getRequestHeader(httpServletRequest, "Accept-Language");
            acceptLanguageList = AcceptLanguageHandler.getAcceptLanguages((String)string);
            ServletHelper.setRequestAttribute((ServletRequest)httpServletRequest, AcceptLanguageList.class.getName(), acceptLanguageList);
        }
        return acceptLanguageList;
    }

    @Nonnull
    public static AcceptMimeTypeList getAcceptMimeTypes(@Nonnull HttpServletRequest httpServletRequest) {
        AcceptMimeTypeList acceptMimeTypeList = (AcceptMimeTypeList)ServletHelper.getRequestAttributeAs((ServletRequest)httpServletRequest, AcceptMimeTypeList.class.getName());
        if (acceptMimeTypeList == null) {
            String string = ServletHelper.getRequestHeader(httpServletRequest, "Accept");
            acceptMimeTypeList = AcceptMimeTypeHandler.getAcceptMimeTypes((String)string);
            ServletHelper.setRequestAttribute((ServletRequest)httpServletRequest, AcceptMimeTypeList.class.getName(), acceptMimeTypeList);
        }
        return acceptMimeTypeList;
    }

    @Nullable
    public static BasicAuthClientCredentials getBasicAuthClientCredentials(@Nonnull HttpServletRequest httpServletRequest) {
        ValueEnforcer.notNull((Object)httpServletRequest, (String)"HttpRequest");
        String string = ServletHelper.getRequestHeader(httpServletRequest, "Authorization");
        return HttpBasicAuth.getBasicAuthClientCredentials((String)string);
    }

    @Nullable
    public static DigestAuthClientCredentials getDigestAuthClientCredentials(@Nonnull HttpServletRequest httpServletRequest) {
        ValueEnforcer.notNull((Object)httpServletRequest, (String)"HttpRequest");
        String string = ServletHelper.getRequestHeader(httpServletRequest, "Authorization");
        return HttpDigestAuth.getDigestAuthClientCredentials((String)string);
    }

    @Nullable
    public static String getHttpUserAgentStringFromRequest(@Nonnull HttpServletRequest httpServletRequest) {
        String string = ServletHelper.getRequestHeader(httpServletRequest, "UA");
        if (string == null && (string = ServletHelper.getRequestHeader(httpServletRequest, "x-device-user-agent")) == null) {
            string = ServletHelper.getRequestHeader(httpServletRequest, "User-Agent");
        }
        return string;
    }

    @Nonnull
    @Nonempty
    public static String getCheckBoxHiddenFieldName(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"FieldName");
        return DEFAULT_CHECKBOX_HIDDEN_FIELD_PREFIX + string;
    }
}

