/*
 * Decompiled with CFR 0.152.
 */
package com.helger.servlet.response.gzip;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.servlet.response.gzip.AbstractCompressedResponseWrapper;
import com.helger.servlet.response.gzip.AbstractCompressedServletOutputStream;
import com.helger.statistics.api.IMutableStatisticsHandlerCounter;
import com.helger.statistics.impl.StatisticsManager;
import jakarta.annotation.Nonnull;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;

public final class GZIPResponse
extends AbstractCompressedResponseWrapper {
    private static final IMutableStatisticsHandlerCounter STATS_COUNTER_GZIP = StatisticsManager.getCounterHandler(GZIPResponse.class);

    public GZIPResponse(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) {
        super(httpServletRequest, httpServletResponse, string);
        STATS_COUNTER_GZIP.increment();
    }

    @Override
    @Nonnull
    protected GZIPServletOutputStream createCompressedOutputStream(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, @Nonnull @Nonempty String string, long l, @Nonnegative long l2) throws IOException {
        return new GZIPServletOutputStream(httpServletRequest, httpServletResponse, string, l, l2);
    }

    public static class GZIPServletOutputStream
    extends AbstractCompressedServletOutputStream {
        public GZIPServletOutputStream(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, @Nonnull String string, long l, @Nonnegative long l2) throws IOException {
            super(httpServletRequest, httpServletResponse, string, l, l2);
        }

        @Override
        @Nonnull
        protected DeflaterOutputStream createDeflaterOutputStream(@Nonnull OutputStream outputStream) throws IOException {
            return new GZIPOutputStream(outputStream);
        }
    }
}

