/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xservlet.forcedredirect;

import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.UsedViaReflection;
import com.helger.base.debug.GlobalDebug;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.ICommonsMap;
import com.helger.web.scope.singleton.AbstractSessionWebSingleton;
import com.helger.xservlet.forcedredirect.ForcedRedirectException;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class ForcedRedirectManager
extends AbstractSessionWebSingleton {
    public static final String REQUEST_PARAMETER_PRG_ACTIVE = "phprga";
    private static final Logger LOGGER = LoggerFactory.getLogger(ForcedRedirectManager.class);
    @GuardedBy(value="m_aRWLock")
    private final ICommonsMap<String, Object> m_aMap = new CommonsHashMap();

    @Deprecated(forRemoval=false)
    @UsedViaReflection
    public ForcedRedirectManager() {
    }

    @Nonnull
    public static ForcedRedirectManager getInstance() {
        return (ForcedRedirectManager)ForcedRedirectManager.getSessionSingleton(ForcedRedirectManager.class);
    }

    @Nullable
    public static ForcedRedirectManager getInstanceIfInstantiated() {
        return (ForcedRedirectManager)ForcedRedirectManager.getSessionSingletonIfInstantiated(ForcedRedirectManager.class);
    }

    public void createForcedRedirect(@Nonnull ForcedRedirectException forcedRedirectException) {
        ValueEnforcer.notNull((Object)forcedRedirectException, (String)"Exception");
        this.m_aRWLock.writeLockedGet(() -> this.m_aMap.put((Object)forcedRedirectException.getSourceMenuItemID(), forcedRedirectException.getContent()));
        if (GlobalDebug.isDebugMode()) {
            LOGGER.info("Creating forced redirect from '" + forcedRedirectException.getSourceMenuItemID() + "' to URL " + forcedRedirectException.getRedirectTargetURL().getAsString());
        }
    }

    @Nullable
    public Object getContent(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return null;
        }
        return this.m_aRWLock.readLockedGet(() -> this.m_aMap.get((Object)string));
    }

    public boolean hasContent(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return false;
        }
        return this.m_aRWLock.readLockedBoolean(() -> this.m_aMap.get((Object)string) != null);
    }

    @Nullable
    public static Object getLastForcedRedirectContent(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return null;
        }
        ForcedRedirectManager forcedRedirectManager = ForcedRedirectManager.getInstanceIfInstantiated();
        if (forcedRedirectManager == null) {
            return null;
        }
        return forcedRedirectManager.getContent(string);
    }

    @Nullable
    public Object getAndRemoveContent(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return null;
        }
        Object object = this.m_aRWLock.writeLockedGet(() -> this.m_aMap.remove((Object)string));
        if (object != null && LOGGER.isDebugEnabled()) {
            LOGGER.debug("Removed content of last forced redirect from '" + string + "'");
        }
        return object;
    }

    @Nullable
    public static Object getAndRemoveLastForcedRedirectContent(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return null;
        }
        ForcedRedirectManager forcedRedirectManager = ForcedRedirectManager.getInstanceIfInstantiated();
        if (forcedRedirectManager == null) {
            return null;
        }
        if (forcedRedirectManager.hasContent(string)) {
            return forcedRedirectManager.getAndRemoveContent(string);
        }
        return null;
    }

    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("Map", this.m_aMap).getToString();
    }
}

