/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xservlet.handler;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.functional.IThrowingConsumer;
import com.helger.base.state.EChange;
import com.helger.base.string.StringImplode;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsEnumMap;
import com.helger.collection.commons.ICommonsMap;
import com.helger.http.EHttpMethod;
import com.helger.servlet.async.ServletAsyncSpec;
import com.helger.xservlet.handler.IXServletHandler;
import com.helger.xservlet.handler.XServletAsyncHandler;
import com.helger.xservlet.handler.simple.IXServletSimpleHandler;
import com.helger.xservlet.handler.simple.XServletHandlerToSimpleHandler;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Consumer;

@NotThreadSafe
public class XServletHandlerRegistry {
    private final ICommonsMap<EHttpMethod, IXServletHandler> m_aHandlers = new CommonsEnumMap(EHttpMethod.class);

    public void registerHandler(@Nonnull EHttpMethod eHttpMethod, @Nonnull IXServletHandler iXServletHandler, boolean bl) {
        ValueEnforcer.notNull((Object)eHttpMethod, (String)"HTTPMethod");
        ValueEnforcer.notNull((Object)iXServletHandler, (String)"Handler");
        if (!bl && this.m_aHandlers.containsKey((Object)eHttpMethod)) {
            throw new IllegalStateException("An HTTP handler for HTTP method " + String.valueOf(eHttpMethod) + " is already registered: " + String.valueOf(this.m_aHandlers.get((Object)eHttpMethod)));
        }
        this.m_aHandlers.put((Object)eHttpMethod, (Object)iXServletHandler);
    }

    public void registerHandler(@Nonnull EHttpMethod eHttpMethod, @Nonnull IXServletSimpleHandler iXServletSimpleHandler) {
        this.registerHandler(eHttpMethod, ServletAsyncSpec.getSync(), iXServletSimpleHandler);
    }

    public void registerHandler(@Nonnull EHttpMethod eHttpMethod, @Nonnull ServletAsyncSpec servletAsyncSpec, @Nonnull IXServletSimpleHandler iXServletSimpleHandler) {
        IXServletHandler iXServletHandler = new XServletHandlerToSimpleHandler(iXServletSimpleHandler);
        if (servletAsyncSpec.isAsynchronous()) {
            iXServletHandler = new XServletAsyncHandler(servletAsyncSpec, iXServletHandler);
        }
        this.registerHandler(eHttpMethod, iXServletHandler, false);
    }

    @Nonnull
    public EChange unregisterHandler(@Nullable EHttpMethod eHttpMethod) {
        if (eHttpMethod == null) {
            return EChange.UNCHANGED;
        }
        return this.m_aHandlers.removeObject((Object)eHttpMethod);
    }

    public EChange copyHandler(@Nonnull EHttpMethod eHttpMethod, @Nonnull @Nonempty Set<EHttpMethod> set) {
        ValueEnforcer.notNull((Object)eHttpMethod, (String)"FromMethod");
        ValueEnforcer.notEmptyNoNullValue(set, (String)"ToMethods");
        IXServletHandler iXServletHandler = this.getHandler(eHttpMethod);
        if (iXServletHandler == null) {
            return EChange.UNCHANGED;
        }
        for (EHttpMethod eHttpMethod2 : set) {
            this.registerHandler(eHttpMethod2, iXServletHandler, false);
        }
        return EChange.CHANGED;
    }

    @Nonnull
    public EChange copyHandlerToAll(@Nonnull EHttpMethod eHttpMethod) {
        EnumSet<EHttpMethod> enumSet = EnumSet.of(EHttpMethod.GET, EHttpMethod.POST, EHttpMethod.PUT, EHttpMethod.DELETE, EHttpMethod.PATCH);
        enumSet.remove(eHttpMethod);
        return this.copyHandler(eHttpMethod, enumSet);
    }

    @Nonnull
    @ReturnsMutableCopy
    public Set<EHttpMethod> getAllowedHTTPMethods() {
        EnumSet<EHttpMethod> enumSet = EnumSet.copyOf(this.m_aHandlers.keySet());
        if (!enumSet.contains(EHttpMethod.GET)) {
            enumSet.remove(EHttpMethod.HEAD);
        }
        return enumSet;
    }

    @Nonnull
    public String getAllowedHttpMethodsString() {
        return StringImplode.getImplodedMapped((String)", ", this.getAllowedHTTPMethods(), EHttpMethod::getName);
    }

    @Nullable
    public IXServletHandler getHandler(@Nonnull EHttpMethod eHttpMethod) {
        return (IXServletHandler)this.m_aHandlers.get((Object)eHttpMethod);
    }

    public void forEachHandler(@Nonnull Consumer<? super IXServletHandler> consumer) {
        this.m_aHandlers.forEachValue(consumer);
    }

    public <EXTYPE extends Throwable> void forEachHandlerThrowing(@Nonnull IThrowingConsumer<? super IXServletHandler, EXTYPE> iThrowingConsumer) throws EXTYPE {
        for (IXServletHandler iXServletHandler : this.m_aHandlers.values()) {
            iThrowingConsumer.accept((Object)iXServletHandler);
        }
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Handlers", this.m_aHandlers).getToString();
    }
}

