/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xservlet.requesttrack;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.web.scope.IRequestWebScope;
import jakarta.annotation.Nonnull;

@Immutable
public final class TrackedRequest {
    private final String m_sRequestID;
    private final IRequestWebScope m_aRequestScope;
    private final long m_nStartMillis;

    public TrackedRequest(@Nonnull @Nonempty String string, @Nonnull IRequestWebScope iRequestWebScope) {
        this.m_sRequestID = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"RequestID");
        this.m_aRequestScope = (IRequestWebScope)ValueEnforcer.notNull((Object)iRequestWebScope, (String)"RequestScope");
        this.m_nStartMillis = System.currentTimeMillis();
    }

    @Nonnull
    @Nonempty
    public String getRequestID() {
        return this.m_sRequestID;
    }

    @Nonnull
    public IRequestWebScope getRequestScope() {
        return this.m_aRequestScope;
    }

    @Nonnegative
    public long getStartTimeMilliseconds() {
        return this.m_nStartMillis;
    }

    @Nonnegative
    public long getRunningMilliseconds() {
        return System.currentTimeMillis() - this.m_nStartMillis;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("RequestID", (Object)this.m_sRequestID).append("RequestScope", (Object)this.m_aRequestScope).append("StartMillis", this.m_nStartMillis).getToString();
    }
}

