/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xservlet.servletstatus;

import com.helger.text.display.IHasDisplayText;
import com.helger.xservlet.servletstatus.EServletStatusText;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;

public enum EServletStatus implements IHasDisplayText
{
    CONSTRUCTED(EServletStatusText.CONSTRUCTED),
    INITED(EServletStatusText.INITED),
    DESTROYED(EServletStatusText.DESTROYED);

    private final IHasDisplayText m_aText;

    private EServletStatus(EServletStatusText eServletStatusText) {
        this.m_aText = eServletStatusText;
    }

    @Nullable
    public String getDisplayText(@Nonnull Locale locale) {
        return this.m_aText.getDisplayText(locale);
    }

    public static boolean isValidSuccessorOf(@Nullable EServletStatus eServletStatus, @Nonnull EServletStatus eServletStatus2) {
        if (eServletStatus == null) {
            return eServletStatus2 == CONSTRUCTED;
        }
        if (eServletStatus == CONSTRUCTED) {
            return eServletStatus2 == INITED;
        }
        if (eServletStatus == INITED) {
            return eServletStatus2 == DESTROYED || eServletStatus2 == CONSTRUCTED;
        }
        return false;
    }
}

