/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xsds.bdxr.smp1;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.style.CodingStyleguideUnaware;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.lang.IExplicitlyCloneable;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.helper.CollectionEqualsHelper;
import com.helger.xsds.bdxr.smp1.ProcessType;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ProcessListType", propOrder={"process"})
@CodingStyleguideUnaware
public class ProcessListType
implements Serializable,
IExplicitlyCloneable {
    @XmlElement(name="Process", required=true)
    private List<ProcessType> process;

    @Nonnull
    @ReturnsMutableObject(value="JAXB implementation style")
    public List<ProcessType> getProcess() {
        if (this.process == null) {
            this.process = new ArrayList<ProcessType>();
        }
        return this.process;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ProcessListType processListType = (ProcessListType)object;
        return CollectionEqualsHelper.equalsCollection(this.process, processListType.process);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.process).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Process", this.process).getToString();
    }

    public void setProcess(@Nullable List<ProcessType> list) {
        this.process = list;
    }

    public boolean hasProcessEntries() {
        return !this.getProcess().isEmpty();
    }

    public boolean hasNoProcessEntries() {
        return this.getProcess().isEmpty();
    }

    @Nonnegative
    public int getProcessCount() {
        return this.getProcess().size();
    }

    @Nullable
    public ProcessType getProcessAtIndex(@Nonnegative int n) throws IndexOutOfBoundsException {
        return this.getProcess().get(n);
    }

    public void addProcess(@Nonnull ProcessType processType) {
        this.getProcess().add(processType);
    }

    public void cloneTo(@Nonnull ProcessListType processListType) {
        if (this.process == null) {
            processListType.process = null;
        } else {
            ArrayList<ProcessType> arrayList = new ArrayList<ProcessType>();
            for (ProcessType processType : this.getProcess()) {
                arrayList.add(processType == null ? null : processType.clone());
            }
            processListType.process = arrayList;
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public ProcessListType clone() {
        ProcessListType processListType = new ProcessListType();
        this.cloneTo(processListType);
        return processListType;
    }
}

