/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xsds.bdxr.smp2.ac;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.style.CodingStyleguideUnaware;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.lang.IExplicitlyCloneable;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.helper.CollectionEqualsHelper;
import com.helger.datetime.xml.XMLOffsetDate;
import com.helger.xsds.bdxr.smp2.ac.CertificateType;
import com.helger.xsds.bdxr.smp2.bc.ActivationDateType;
import com.helger.xsds.bdxr.smp2.bc.AddressURIType;
import com.helger.xsds.bdxr.smp2.bc.ContactType;
import com.helger.xsds.bdxr.smp2.bc.DescriptionType;
import com.helger.xsds.bdxr.smp2.bc.ExpirationDateType;
import com.helger.xsds.bdxr.smp2.bc.TransportProfileIDType;
import com.helger.xsds.bdxr.smp2.ec.SMPExtensionsType;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="EndpointType", propOrder={"smpExtensions", "transportProfileID", "description", "contact", "addressURI", "activationDate", "expirationDate", "certificate"})
@CodingStyleguideUnaware
public class EndpointType
implements Serializable,
IExplicitlyCloneable {
    @XmlElement(name="SMPExtensions", namespace="http://docs.oasis-open.org/bdxr/ns/SMP/2/ExtensionComponents")
    private SMPExtensionsType smpExtensions;
    @XmlElement(name="TransportProfileID", namespace="http://docs.oasis-open.org/bdxr/ns/SMP/2/BasicComponents", required=true)
    private TransportProfileIDType transportProfileID;
    @XmlElement(name="Description", namespace="http://docs.oasis-open.org/bdxr/ns/SMP/2/BasicComponents")
    private DescriptionType description;
    @XmlElement(name="Contact", namespace="http://docs.oasis-open.org/bdxr/ns/SMP/2/BasicComponents")
    private ContactType contact;
    @XmlElement(name="AddressURI", namespace="http://docs.oasis-open.org/bdxr/ns/SMP/2/BasicComponents")
    private AddressURIType addressURI;
    @XmlElement(name="ActivationDate", namespace="http://docs.oasis-open.org/bdxr/ns/SMP/2/BasicComponents")
    private ActivationDateType activationDate;
    @XmlElement(name="ExpirationDate", namespace="http://docs.oasis-open.org/bdxr/ns/SMP/2/BasicComponents")
    private ExpirationDateType expirationDate;
    @XmlElement(name="Certificate")
    private List<CertificateType> certificate;

    @Nullable
    public SMPExtensionsType getSMPExtensions() {
        return this.smpExtensions;
    }

    public void setSMPExtensions(@Nullable SMPExtensionsType sMPExtensionsType) {
        this.smpExtensions = sMPExtensionsType;
    }

    @Nullable
    public TransportProfileIDType getTransportProfileID() {
        return this.transportProfileID;
    }

    public void setTransportProfileID(@Nullable TransportProfileIDType transportProfileIDType) {
        this.transportProfileID = transportProfileIDType;
    }

    @Nullable
    public DescriptionType getDescription() {
        return this.description;
    }

    public void setDescription(@Nullable DescriptionType descriptionType) {
        this.description = descriptionType;
    }

    @Nullable
    public ContactType getContact() {
        return this.contact;
    }

    public void setContact(@Nullable ContactType contactType) {
        this.contact = contactType;
    }

    @Nullable
    public AddressURIType getAddressURI() {
        return this.addressURI;
    }

    public void setAddressURI(@Nullable AddressURIType addressURIType) {
        this.addressURI = addressURIType;
    }

    @Nullable
    public ActivationDateType getActivationDate() {
        return this.activationDate;
    }

    public void setActivationDate(@Nullable ActivationDateType activationDateType) {
        this.activationDate = activationDateType;
    }

    @Nullable
    public ExpirationDateType getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(@Nullable ExpirationDateType expirationDateType) {
        this.expirationDate = expirationDateType;
    }

    @Nonnull
    @ReturnsMutableObject(value="JAXB implementation style")
    public List<CertificateType> getCertificate() {
        if (this.certificate == null) {
            this.certificate = new ArrayList<CertificateType>();
        }
        return this.certificate;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        EndpointType endpointType = (EndpointType)object;
        if (!EqualsHelper.equals((Object)this.activationDate, (Object)endpointType.activationDate)) {
            return false;
        }
        if (!EqualsHelper.equals((Object)this.addressURI, (Object)endpointType.addressURI)) {
            return false;
        }
        if (!CollectionEqualsHelper.equalsCollection(this.certificate, endpointType.certificate)) {
            return false;
        }
        if (!EqualsHelper.equals((Object)this.contact, (Object)endpointType.contact)) {
            return false;
        }
        if (!EqualsHelper.equals((Object)this.description, (Object)endpointType.description)) {
            return false;
        }
        if (!EqualsHelper.equals((Object)this.expirationDate, (Object)endpointType.expirationDate)) {
            return false;
        }
        if (!EqualsHelper.equals((Object)this.smpExtensions, (Object)endpointType.smpExtensions)) {
            return false;
        }
        return EqualsHelper.equals((Object)this.transportProfileID, (Object)endpointType.transportProfileID);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.activationDate).append((Object)this.addressURI).append(this.certificate).append((Object)this.contact).append((Object)this.description).append((Object)this.expirationDate).append((Object)this.smpExtensions).append((Object)this.transportProfileID).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("ActivationDate", (Object)this.activationDate).append("AddressURI", (Object)this.addressURI).append("Certificate", this.certificate).append("Contact", (Object)this.contact).append("Description", (Object)this.description).append("ExpirationDate", (Object)this.expirationDate).append("SmpExtensions", (Object)this.smpExtensions).append("TransportProfileID", (Object)this.transportProfileID).getToString();
    }

    public void setCertificate(@Nullable List<CertificateType> list) {
        this.certificate = list;
    }

    public boolean hasCertificateEntries() {
        return !this.getCertificate().isEmpty();
    }

    public boolean hasNoCertificateEntries() {
        return this.getCertificate().isEmpty();
    }

    @Nonnegative
    public int getCertificateCount() {
        return this.getCertificate().size();
    }

    @Nullable
    public CertificateType getCertificateAtIndex(@Nonnegative int n) throws IndexOutOfBoundsException {
        return this.getCertificate().get(n);
    }

    public void addCertificate(@Nonnull CertificateType certificateType) {
        this.getCertificate().add(certificateType);
    }

    public void cloneTo(@Nonnull EndpointType endpointType) {
        endpointType.activationDate = this.activationDate == null ? null : this.activationDate.clone();
        AddressURIType addressURIType = endpointType.addressURI = this.addressURI == null ? null : this.addressURI.clone();
        if (this.certificate == null) {
            endpointType.certificate = null;
        } else {
            ArrayList<CertificateType> arrayList = new ArrayList<CertificateType>();
            for (CertificateType certificateType : this.getCertificate()) {
                arrayList.add(certificateType == null ? null : certificateType.clone());
            }
            endpointType.certificate = arrayList;
        }
        endpointType.contact = this.contact == null ? null : this.contact.clone();
        endpointType.description = this.description == null ? null : this.description.clone();
        endpointType.expirationDate = this.expirationDate == null ? null : this.expirationDate.clone();
        endpointType.smpExtensions = this.smpExtensions == null ? null : this.smpExtensions.clone();
        endpointType.transportProfileID = this.transportProfileID == null ? null : this.transportProfileID.clone();
    }

    @Nonnull
    @ReturnsMutableCopy
    public EndpointType clone() {
        EndpointType endpointType = new EndpointType();
        this.cloneTo(endpointType);
        return endpointType;
    }

    @Nonnull
    public TransportProfileIDType setTransportProfileID(@Nullable String string) {
        TransportProfileIDType transportProfileIDType = this.getTransportProfileID();
        if (transportProfileIDType == null) {
            transportProfileIDType = new TransportProfileIDType(string);
            this.setTransportProfileID(transportProfileIDType);
        } else {
            transportProfileIDType.setValue(string);
        }
        return transportProfileIDType;
    }

    @Nonnull
    public DescriptionType setDescription(@Nullable String string) {
        DescriptionType descriptionType = this.getDescription();
        if (descriptionType == null) {
            descriptionType = new DescriptionType(string);
            this.setDescription(descriptionType);
        } else {
            descriptionType.setValue(string);
        }
        return descriptionType;
    }

    @Nonnull
    public ContactType setContact(@Nullable String string) {
        ContactType contactType = this.getContact();
        if (contactType == null) {
            contactType = new ContactType(string);
            this.setContact(contactType);
        } else {
            contactType.setValue(string);
        }
        return contactType;
    }

    @Nonnull
    public AddressURIType setAddressURI(@Nullable String string) {
        AddressURIType addressURIType = this.getAddressURI();
        if (addressURIType == null) {
            addressURIType = new AddressURIType(string);
            this.setAddressURI(addressURIType);
        } else {
            addressURIType.setValue(string);
        }
        return addressURIType;
    }

    @Nonnull
    public ActivationDateType setActivationDate(@Nullable XMLOffsetDate xMLOffsetDate) {
        ActivationDateType activationDateType = this.getActivationDate();
        if (activationDateType == null) {
            activationDateType = new ActivationDateType(xMLOffsetDate);
            this.setActivationDate(activationDateType);
        } else {
            activationDateType.setValue(xMLOffsetDate);
        }
        return activationDateType;
    }

    @Nonnull
    public ActivationDateType setActivationDate(@Nullable LocalDate localDate) {
        ActivationDateType activationDateType = this.getActivationDate();
        if (activationDateType == null) {
            activationDateType = new ActivationDateType(localDate);
            this.setActivationDate(activationDateType);
        } else {
            activationDateType.setValue(localDate);
        }
        return activationDateType;
    }

    @Nonnull
    public ExpirationDateType setExpirationDate(@Nullable XMLOffsetDate xMLOffsetDate) {
        ExpirationDateType expirationDateType = this.getExpirationDate();
        if (expirationDateType == null) {
            expirationDateType = new ExpirationDateType(xMLOffsetDate);
            this.setExpirationDate(expirationDateType);
        } else {
            expirationDateType.setValue(xMLOffsetDate);
        }
        return expirationDateType;
    }

    @Nonnull
    public ExpirationDateType setExpirationDate(@Nullable LocalDate localDate) {
        ExpirationDateType expirationDateType = this.getExpirationDate();
        if (expirationDateType == null) {
            expirationDateType = new ExpirationDateType(localDate);
            this.setExpirationDate(expirationDateType);
        } else {
            expirationDateType.setValue(localDate);
        }
        return expirationDateType;
    }

    @Nullable
    public String getTransportProfileIDValue() {
        TransportProfileIDType transportProfileIDType = this.getTransportProfileID();
        return transportProfileIDType == null ? null : transportProfileIDType.getValue();
    }

    @Nullable
    public String getDescriptionValue() {
        DescriptionType descriptionType = this.getDescription();
        return descriptionType == null ? null : descriptionType.getValue();
    }

    @Nullable
    public String getContactValue() {
        ContactType contactType = this.getContact();
        return contactType == null ? null : contactType.getValue();
    }

    @Nullable
    public String getAddressURIValue() {
        AddressURIType addressURIType = this.getAddressURI();
        return addressURIType == null ? null : addressURIType.getValue();
    }

    @Nullable
    public XMLOffsetDate getActivationDateValue() {
        ActivationDateType activationDateType = this.getActivationDate();
        return activationDateType == null ? null : activationDateType.getValue();
    }

    @Nullable
    public LocalDate getActivationDateValueLocal() {
        ActivationDateType activationDateType = this.getActivationDate();
        return activationDateType == null ? null : activationDateType.getValueLocal();
    }

    @Nullable
    public XMLOffsetDate getExpirationDateValue() {
        ExpirationDateType expirationDateType = this.getExpirationDate();
        return expirationDateType == null ? null : expirationDateType.getValue();
    }

    @Nullable
    public LocalDate getExpirationDateValueLocal() {
        ExpirationDateType expirationDateType = this.getExpirationDate();
        return expirationDateType == null ? null : expirationDateType.getValueLocal();
    }
}

