/*
 * Decompiled with CFR 0.152.
 */
package com.holdenkarau.spark.testing;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.holdenkarau.spark.testing.Utils$;
import com.holdenkarau.spark.testing.YARNClusterLike;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.MiniYARNCluster;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.SystemProperties;
import scala.sys.package$;

public abstract class YARNClusterLike$class {
    public static void startYARN(YARNClusterLike $this) {
        $this.com$holdenkarau$spark$testing$YARNClusterLike$$tempDir_$eq(Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1()));
        $this.com$holdenkarau$spark$testing$YARNClusterLike$$logConfDir_$eq(new File($this.com$holdenkarau$spark$testing$YARNClusterLike$$tempDir(), "log4j"));
        $this.com$holdenkarau$spark$testing$YARNClusterLike$$logConfDir().mkdir();
        System.setProperty("SPARK_YARN_MODE", "true");
        File logConfFile = new File($this.com$holdenkarau$spark$testing$YARNClusterLike$$logConfDir(), "log4j.properties");
        Files.write((CharSequence)$this.com$holdenkarau$spark$testing$YARNClusterLike$$LOG4J_CONF(), (File)logConfFile, (Charset)Charsets.UTF_8);
        YarnConfiguration yarnConf = new YarnConfiguration();
        $this.com$holdenkarau$spark$testing$YARNClusterLike$$yarnCluster_$eq((Option<MiniYARNCluster>)new Some((Object)new MiniYARNCluster($this.getClass().getName(), 1, 1, 1)));
        $this.com$holdenkarau$spark$testing$YARNClusterLike$$yarnCluster().foreach((Function1)new Serializable($this, yarnConf){
            public static final long serialVersionUID = 0L;
            private final YarnConfiguration yarnConf$1;

            public final void apply(MiniYARNCluster x$1) {
                x$1.init((Configuration)this.yarnConf$1);
            }
            {
                this.yarnConf$1 = yarnConf$1;
            }
        });
        $this.com$holdenkarau$spark$testing$YARNClusterLike$$yarnCluster().foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final void apply(MiniYARNCluster x$2) {
                x$2.start();
            }
        });
        Option config = $this.com$holdenkarau$spark$testing$YARNClusterLike$$yarnCluster().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Configuration apply(MiniYARNCluster x$3) {
                return x$3.getConfig();
            }
        });
        long deadline = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(10L);
        while (true) {
            Option option = config.map((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final String apply(Configuration x$4) {
                    return x$4.get("yarn.resourcemanager.address").split(":")[1];
                }
            });
            Some some = new Some((Object)"0");
            if (option != null ? !option.equals(some) : some != null) break;
            if (System.currentTimeMillis() > deadline) {
                throw new IllegalStateException("Timed out waiting for RM to come up.");
            }
            TimeUnit.MILLISECONDS.sleep(100L);
        }
        Properties props = $this.setupSparkProperties();
        File propsFile = File.createTempFile("spark", ".properties", $this.com$holdenkarau$spark$testing$YARNClusterLike$$tempDir());
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(propsFile), Charsets.UTF_8);
        props.store(writer, "Spark properties.");
        writer.close();
    }

    public static Properties setupSparkProperties(YARNClusterLike $this) {
        Option<String> sparkAssemblyJar = $this.getAssemblyJar();
        Option<String> sparkAssemblyPath = $this.getSparkAssemblyPath();
        sparkAssemblyJar.foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final SystemProperties apply(String jar) {
                return package$.MODULE$.props().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.yarn.jar"), (Object)new StringBuilder().append((Object)"local:").append((Object)jar).toString()));
            }
        });
        sparkAssemblyPath.foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final SystemProperties apply(String path) {
                return package$.MODULE$.props().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.yarn.jars"), (Object)new StringBuilder().append((Object)"local:").append((Object)path).append((Object)"*").toString()));
            }
        });
        package$.MODULE$.props().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.executor.instances"), (Object)"1"));
        String childClasspath = $this.generateClassPath();
        package$.MODULE$.props().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.driver.extraClassPath"), (Object)childClasspath));
        package$.MODULE$.props().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.executor.extraClassPath"), (Object)childClasspath));
        String sparkHome = (String)package$.MODULE$.env().apply((Object)"SPARK_HOME");
        package$.MODULE$.props().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.yarn.jars"), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/jars/*.jar"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sparkHome}))));
        File configurationFile = new File($this.com$holdenkarau$spark$testing$YARNClusterLike$$configurationFilePath());
        Object object = configurationFile.exists() ? BoxesRunTime.boxToBoolean((boolean)configurationFile.delete()) : BoxedUnit.UNIT;
        Option configuration = $this.com$holdenkarau$spark$testing$YARNClusterLike$$yarnCluster().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Configuration apply(MiniYARNCluster x$5) {
                return x$5.getConfig();
            }
        });
        configuration.foreach((Function1)new Serializable($this, configurationFile){
            public static final long serialVersionUID = 0L;
            private final File configurationFile$1;

            public final void apply(Configuration config) {
                JavaConversions$.MODULE$.iterableAsScalaIterable((java.lang.Iterable)config).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final SystemProperties apply(Map.Entry<String, String> e) {
                        return package$.MODULE$.props().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder().append((Object)"spark.hadoop.").append((Object)e.getKey()).toString()), (Object)e.getValue()));
                    }
                });
                config.writeXml((OutputStream)new FileOutputStream(this.configurationFile$1));
            }
            {
                this.configurationFile$1 = configurationFile$1;
            }
        });
        Properties props = new Properties();
        package$.MODULE$.props().foreach((Function1)new Serializable($this, props){
            public static final long serialVersionUID = 0L;
            private final Properties props$1;

            public final Object apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    BoxedUnit boxedUnit = k.startsWith("spark.") ? this.props$1.setProperty(k, v) : BoxedUnit.UNIT;
                    return boxedUnit;
                }
                throw new MatchError(tuple2);
            }
            {
                this.props$1 = props$1;
            }
        });
        return props;
    }

    public static Option getAssemblyJar(YARNClusterLike $this) {
        List sparkAssemblyDirs = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder().append((Object)((String)package$.MODULE$.env().apply((Object)"SPARK_HOME"))).append((Object)"/assembly/target/scala-2.10/").toString(), new StringBuilder().append((Object)((String)package$.MODULE$.env().apply((Object)"SPARK_HOME"))).append((Object)"/assembly/target/scala-2.11/").toString()}));
        List sparkLibDir = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder().append((Object)((String)package$.MODULE$.env().apply((Object)"SPARK_HOME"))).append((Object)"/lib/").toString()}));
        List candidateDirs = (List)sparkAssemblyDirs.$plus$plus((GenTraversableOnce)sparkLibDir, List$.MODULE$.canBuildFrom());
        List candidates = (List)((List)((TraversableLike)candidateDirs.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final File apply(String dir) {
                return new File(dir);
            }
        }, List$.MODULE$.canBuildFrom())).filter((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File x$6) {
                return x$6.exists();
            }
        })).flatMap((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final ArrayOps<File> apply(File x$7) {
                return Predef$.MODULE$.refArrayOps((Object[])x$7.listFiles());
            }
        }, List$.MODULE$.canBuildFrom());
        Option sparkAssemblyJar = candidates.find((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File f) {
                String name = f.getName();
                return name.endsWith(".jar") && name.startsWith("spark-assembly");
            }
        }).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(File f) {
                return f.getAbsolutePath();
            }
        });
        return sparkAssemblyJar;
    }

    public static Option getSparkAssemblyPath(YARNClusterLike $this) {
        List sparkAssemblyDirs = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder().append((Object)((String)package$.MODULE$.env().apply((Object)"SPARK_HOME"))).append((Object)"/assembly/target/scala-2.10/").toString(), new StringBuilder().append((Object)((String)package$.MODULE$.env().apply((Object)"SPARK_HOME"))).append((Object)"/assembly/target/scala-2.11/").toString()}));
        List sparkLibDir = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder().append((Object)((String)package$.MODULE$.env().apply((Object)"SPARK_HOME"))).append((Object)"/lib/").toString()}));
        List candidateDirs = (List)sparkAssemblyDirs.$plus$plus((GenTraversableOnce)sparkLibDir, List$.MODULE$.canBuildFrom());
        List candidates = (List)candidateDirs.filter((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String dir) {
                return new File(dir).exists();
            }
        });
        return candidates.headOption();
    }

    /*
     * WARNING - void declaration
     */
    public static String generateClassPath(YARNClusterLike $this) {
        void var2_2;
        List clList = (List)((List)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{$this.com$holdenkarau$spark$testing$YARNClusterLike$$logConfDir().getAbsolutePath(), (String)package$.MODULE$.props().apply((Object)"java.class.path")})).$plus$plus($this.classPathFromCurrentClassLoader(), List$.MODULE$.canBuildFrom())).$plus$plus($this.extraClassPath(), List$.MODULE$.canBuildFrom());
        String clPath = clList.mkString(File.pathSeparator);
        return var2_2;
    }

    public static Seq classPathFromCurrentClassLoader(YARNClusterLike $this) {
        URLClassLoader uRLClassLoader;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URLClassLoader uRLClassLoader2 = classLoader instanceof URLClassLoader ? (uRLClassLoader = (URLClassLoader)classLoader) : (URLClassLoader)classLoader.getParent();
        URLClassLoader urlClassLoader = uRLClassLoader2;
        return (Seq)Predef$.MODULE$.refArrayOps((Object[])urlClassLoader.getURLs()).toSeq().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(URL u) {
                return new File(u.toURI()).getAbsolutePath();
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public static Seq extraClassPath(YARNClusterLike $this) {
        return (Seq)((List)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{new File("target/scala-2.10/classes"), new File("target/scala-2.10/test-classes"), new File("target/classes"), new File("target/test-classes")})).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Option<String> apply(File x) {
                return Option$.MODULE$.apply((Object)x.getAbsolutePath());
            }
        }, List$.MODULE$.canBuildFrom())).flatMap((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Iterable<String> apply(Option<String> x) {
                return Option$.MODULE$.option2Iterable(x);
            }
        }, List$.MODULE$.canBuildFrom());
    }

    public static void shutdownYARN(YARNClusterLike $this) {
        $this.com$holdenkarau$spark$testing$YARNClusterLike$$yarnCluster().foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final void apply(MiniYARNCluster x$8) {
                x$8.stop();
            }
        });
        System.clearProperty("SPARK_YARN_MODE");
        $this.com$holdenkarau$spark$testing$YARNClusterLike$$yarnCluster_$eq((Option<MiniYARNCluster>)None$.MODULE$);
    }

    public static void $init$(YARNClusterLike $this) {
        $this.com$holdenkarau$spark$testing$YARNClusterLike$_setter_$com$holdenkarau$spark$testing$YARNClusterLike$$LOG4J_CONF_$eq(new StringOps(Predef$.MODULE$.augmentString("\n      |log4j.rootCategory=DEBUG, console\n      |log4j.appender.console=org.apache.log4j.ConsoleAppender\n      |log4j.appender.console.target=System.err\n      |log4j.appender.console.layout=org.apache.log4j.PatternLayout\n      |log4j.appender.console.layout.ConversionPattern=%d{yy/MM/dd HH:mm:ss} %p %c{1}: %m%n\n    ")).stripMargin());
        $this.com$holdenkarau$spark$testing$YARNClusterLike$_setter_$com$holdenkarau$spark$testing$YARNClusterLike$$configurationFilePath_$eq(new StringBuilder().append((Object)new File($this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath()).getParentFile().getAbsolutePath()).append((Object)"/hadoop-site.xml").toString());
        $this.com$holdenkarau$spark$testing$YARNClusterLike$$yarnCluster_$eq((Option<MiniYARNCluster>)None$.MODULE$);
    }
}

