/*
 * Decompiled with CFR 0.152.
 */
package com.invincea.spark.hash;

import com.invincea.spark.hash.LSH;
import com.invincea.spark.hash.LSHModel;
import java.io.File;
import java.io.PrintWriter;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenSeq;
import scala.collection.Iterable;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class OpenPortApp$ {
    public static final OpenPortApp$ MODULE$;

    static {
        new OpenPortApp$();
    }

    public void main(String[] args) {
        if (args.length != 3) {
            Predef$.MODULE$.println((Object)"Usage: OpenPortApp <file> <partitions> <data_sample>");
            System.exit(1);
        }
        String file = args[0];
        int partitions = new StringOps(Predef$.MODULE$.augmentString(args[1])).toInt();
        float data_sample = new StringOps(Predef$.MODULE$.augmentString(args[2])).toFloat();
        SparkConf conf = new SparkConf().setAppName("Open Port LSH");
        SparkContext sc = new SparkContext(conf);
        RDD qual$1 = sc.objectFile(file, sc.objectFile$default$2(), ClassTag$.MODULE$.apply(Tuple2.class));
        int x$1 = partitions;
        Ordering x$2 = qual$1.repartition$default$2(x$1);
        RDD port_set = qual$1.repartition(x$1, x$2);
        RDD port_set_filtered = port_set.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<List<Object>, Object> tpl) {
                return ((SeqLike)tpl._1()).size() >= 2;
            }
        });
        RDD qual$2 = port_set_filtered.sample(false, (double)data_sample, port_set_filtered.sample$default$3());
        int x$3 = partitions;
        Ordering x$4 = qual$2.repartition$default$2(x$3);
        RDD sample = qual$2.repartition(x$3, x$4);
        RDD points = sample.zipWithIndex().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Tuple2<List<Object>, Object>> apply(Tuple2<Tuple2<List<Object>, Object>, Object> x) {
                return x.swap();
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        RDD vctr = sample.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<Tuple2<Object, Object>> apply(Tuple2<List<Object>, Object> r) {
                return (List)((TraversableLike)r._1()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, Object> apply(int i) {
                        return new Tuple2.mcID.sp(i, 1.0);
                    }
                }, List$.MODULE$.canBuildFrom());
            }
        }, ClassTag$.MODULE$.apply(List.class)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final SparseVector apply(List<Tuple2<Object, Object>> a) {
                return (SparseVector)Vectors$.MODULE$.sparse(65535, a);
            }
        }, ClassTag$.MODULE$.apply(SparseVector.class));
        LSH lsh = new LSH((RDD<SparseVector>)vctr, 65537, 1000, 1000, 25, 2);
        LSHModel model = lsh.run();
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"samples: ").append((Object)BoxesRunTime.boxToLong((long)sample.count())).toString());
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"clusters: ").append((Object)BoxesRunTime.boxToLong((long)model.clusters().count())).toString());
        RDD points_clustered_scores = RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(points, ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Long$.MODULE$).join(model.vector_cluster()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Tuple2<List<Object>, Object>> apply(Tuple2<Object, Tuple2<Tuple2<List<Object>, Object>, Object>> x) {
                return new Tuple2((Object)BoxesRunTime.boxToLong((long)((Tuple2)x._2())._2$mcJ$sp()), ((Tuple2)x._2())._1());
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Long$.MODULE$).groupByKey(), ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.apply(Iterable.class), (Ordering)Ordering.Long$.MODULE$).join(model.scores());
        Tuple4[] score_coverage_size = (Tuple4[])points_clustered_scores.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple4<Object, Object, Object, Object> apply(Tuple2<Object, Tuple2<Iterable<Tuple2<List<Object>, Object>>, Object>> x) {
                return new Tuple4((Object)BoxesRunTime.boxToDouble((double)((Tuple2)x._2())._2$mcD$sp()), (Object)BoxesRunTime.boxToInteger((int)((SeqLike)((SeqLike)((TraversableOnce)((Tuple2)x._2())._1()).foldLeft((Object)Nil$.MODULE$, (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final List<Nothing$> apply(List<Nothing$> a1, Tuple2<List<Object>, Object> b1) {
                        return (List)a1.union((GenSeq)((List)b1._1()), List$.MODULE$.canBuildFrom());
                    }
                })).distinct()).size()), (Object)BoxesRunTime.boxToInteger((int)((TraversableOnce)((Tuple2)x._2())._1()).size()), ((TraversableOnce)((Tuple2)x._2())._1()).foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(int a, Tuple2<List<Object>, Object> b) {
                        return a + b._2$mcI$sp();
                    }
                }));
            }
        }, ClassTag$.MODULE$.apply(Tuple4.class)).collect();
        PrintWriter writer = new PrintWriter(new File("results.csv"));
        writer.write("score,port_coverage,cluster_size,num_ips\n");
        Predef$.MODULE$.refArrayOps((Object[])score_coverage_size).foreach((Function1)new Serializable(writer){
            public static final long serialVersionUID = 0L;
            private final PrintWriter writer$1;

            public final void apply(Tuple4<Object, Object, Object, Object> x) {
                this.writer$1.write(new StringBuilder().append(BoxesRunTime.unboxToDouble((Object)x._1())).append((Object)",").append(x._2()).append((Object)",").append(x._3()).append((Object)",").append(x._4()).append((Object)"\n").toString());
            }
            {
                this.writer$1 = writer$1;
            }
        });
        writer.flush();
        writer.close();
    }

    private OpenPortApp$() {
        MODULE$ = this;
    }
}

