/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.response;

import com.jayway.restassured.internal.MultiValueEntity;
import com.jayway.restassured.internal.assertion.AssertParameter;
import com.jayway.restassured.response.Cookie;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cookies
implements Iterable<Cookie> {
    private final MultiValueEntity<Cookie> cookies;

    public Cookies(Cookie ... cookies) {
        this(Arrays.asList(cookies));
    }

    public Cookies(List<Cookie> cookies) {
        AssertParameter.notNull(cookies, (String)"Cookies");
        this.cookies = new MultiValueEntity<Cookie>(cookies);
    }

    public int size() {
        return this.cookies.size();
    }

    public boolean exist() {
        return this.cookies.exist();
    }

    public boolean hasCookieWithName(String cookieName) {
        return this.cookies.hasEntityWithName(cookieName);
    }

    protected List<Cookie> list() {
        return this.cookies.list();
    }

    public Cookie get(String cookieName) {
        AssertParameter.notNull((Object)cookieName, (String)"Cookie name");
        return this.cookies.get(cookieName);
    }

    public String getValue(String cookieName) {
        AssertParameter.notNull((Object)cookieName, (String)"Cookie name");
        return this.cookies.getValue(cookieName);
    }

    public List<Cookie> getList(String cookieName) {
        return this.cookies.getList(cookieName);
    }

    public List<String> getValues(String cookieName) {
        return this.cookies.getValues(cookieName);
    }

    @Override
    public Iterator<Cookie> iterator() {
        return this.cookies.iterator();
    }

    public static Cookies cookies(Cookie cookie, Cookie ... additionalCookies) {
        AssertParameter.notNull((Object)cookie, (String)"Cookie");
        LinkedList<Cookie> cookieList = new LinkedList<Cookie>();
        cookieList.add(cookie);
        Collections.addAll(cookieList, additionalCookies);
        return new Cookies(cookieList);
    }

    public String toString() {
        return this.cookies.toString();
    }
}

