/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.log4j.aws;

import com.kdgregory.log4j.aws.internal.cloudwatch.CloudWatchConstants;
import com.kdgregory.log4j.aws.internal.cloudwatch.CloudWatchLogWriter;
import com.kdgregory.log4j.aws.internal.shared.DefaultThreadFactory;
import com.kdgregory.log4j.aws.internal.shared.LogMessage;
import com.kdgregory.log4j.aws.internal.shared.LogWriter;
import com.kdgregory.log4j.aws.internal.shared.Substitutions;
import com.kdgregory.log4j.aws.internal.shared.ThreadFactory;
import com.kdgregory.log4j.aws.internal.shared.WriterFactory;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;

public class CloudWatchAppender
extends AppenderSkeleton {
    private volatile boolean ready = false;
    private volatile boolean closed = false;
    protected ThreadFactory threadFactory = new DefaultThreadFactory();
    protected WriterFactory writerFactory = new WriterFactory(){

        @Override
        public LogWriter newLogWriter() {
            return new CloudWatchLogWriter(CloudWatchAppender.this.actualLogGroup, CloudWatchAppender.this.actualLogStream, CloudWatchAppender.this.batchDelay);
        }
    };
    protected volatile LogWriter writer;
    protected volatile long lastRotationTimestamp;
    protected volatile int lastRotationCount;
    protected volatile Throwable lastWriterException;
    private Object initializationLock = new Object();
    private Object messageQueueLock = new Object();
    private String actualLogGroup;
    private String actualLogStream;
    private String logGroup;
    private String logStream = "{startTimestamp}";
    private long batchDelay = 2000L;
    private RotationMode rotationMode = RotationMode.none;
    private long rotationInterval = -1L;
    private AtomicInteger sequence = new AtomicInteger();

    public void setLogGroup(String value) {
        this.logGroup = value;
    }

    public String getLogGroup() {
        return this.logGroup;
    }

    public String getActualLogGroup() {
        return this.actualLogGroup;
    }

    public void setLogStream(String value) {
        this.logStream = value;
    }

    public String getLogStream() {
        return this.logStream;
    }

    public String getActualLogStream() {
        return this.actualLogStream;
    }

    public void setBatchDelay(long value) {
        this.batchDelay = value;
        if (this.writer != null) {
            this.writer.setBatchDelay(value);
        }
    }

    public long getBatchDelay() {
        return this.batchDelay;
    }

    public void setRotationMode(String value) {
        try {
            this.rotationMode = RotationMode.valueOf(value);
        }
        catch (IllegalArgumentException ex) {
            this.rotationMode = RotationMode.none;
            LogLog.error((String)("invalid rotationMode: " + value));
        }
    }

    public String getRotationMode() {
        return this.rotationMode.name();
    }

    public void setRotationInterval(long value) {
        this.rotationInterval = value;
    }

    public long getRotationInterval() {
        return this.rotationInterval;
    }

    public void setSequence(int value) {
        this.sequence.set(value);
    }

    public int getSequence() {
        return this.sequence.get();
    }

    protected void append(LoggingEvent event) {
        if (this.closed) {
            throw new IllegalStateException("appender is closed");
        }
        if (!this.ready) {
            this.initialize();
        }
        this.internalAppend(LogMessage.create(event, this.getLayout()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.initializationLock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.stopWriter();
            this.closed = true;
        }
    }

    public boolean requiresLayout() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rotate() {
        Object object = this.initializationLock;
        synchronized (object) {
            this.stopWriter();
            this.sequence.incrementAndGet();
            this.startWriter();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        Object object = this.initializationLock;
        synchronized (object) {
            if (this.ready) {
                return;
            }
            this.startWriter();
            this.ready = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startWriter() {
        Object object = this.initializationLock;
        synchronized (object) {
            try {
                Substitutions subs = new Substitutions(new Date(), this.sequence.get());
                this.actualLogGroup = CloudWatchConstants.ALLOWED_NAME_REGEX.matcher(subs.perform(this.logGroup)).replaceAll("");
                this.actualLogStream = CloudWatchConstants.ALLOWED_NAME_REGEX.matcher(subs.perform(this.logStream)).replaceAll("");
                this.writer = this.writerFactory.newLogWriter();
                this.threadFactory.startLoggingThread(this.writer, new Thread.UncaughtExceptionHandler(){

                    @Override
                    public void uncaughtException(Thread t, Throwable ex) {
                        LogLog.error((String)"CloudWatchLogWriter failure", (Throwable)ex);
                        CloudWatchAppender.this.writer = null;
                        CloudWatchAppender.this.lastWriterException = ex;
                    }
                });
                if (this.layout.getHeader() != null) {
                    this.internalAppend(LogMessage.create(this.layout.getHeader()));
                }
                this.lastRotationTimestamp = System.currentTimeMillis();
                this.lastRotationCount = 0;
            }
            catch (Exception ex) {
                LogLog.error((String)"exception while initializing writer", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopWriter() {
        Object object = this.initializationLock;
        synchronized (object) {
            if (this.writer == null) {
                return;
            }
            if (this.layout.getFooter() != null) {
                this.internalAppend(LogMessage.create(this.layout.getFooter()));
            }
            this.writer.stop();
            this.writer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalAppend(LogMessage message) {
        if (message == null) {
            return;
        }
        if (message.size() + 26 >= 0x100000) {
            LogLog.warn((String)"attempted to append a message > AWS batch size; ignored");
            return;
        }
        this.rotateIfNeeded(System.currentTimeMillis());
        Object object = this.messageQueueLock;
        synchronized (object) {
            if (this.writer == null) {
                LogLog.warn((String)"appender not properly configured: writer is null");
            } else {
                this.writer.addMessage(message);
                ++this.lastRotationCount;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rotateIfNeeded(long now) {
        if (this.shouldRotate(now)) {
            Object object = this.initializationLock;
            synchronized (object) {
                if (this.shouldRotate(now)) {
                    this.rotate();
                }
            }
        }
    }

    private boolean shouldRotate(long now) {
        switch (this.rotationMode) {
            case none: {
                return false;
            }
            case count: {
                return this.rotationInterval > 0L && (long)this.lastRotationCount >= this.rotationInterval;
            }
            case interval: {
                return this.rotationInterval > 0L && now - this.lastRotationTimestamp > this.rotationInterval;
            }
            case hourly: {
                return this.lastRotationTimestamp / 3600000L < now / 3600000L;
            }
            case daily: {
                return this.lastRotationTimestamp / 86400000L < now / 86400000L;
            }
        }
        return false;
    }

    public static enum RotationMode {
        none,
        count,
        interval,
        hourly,
        daily;

    }
}

