/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.log4j.aws.internal.shared;

import com.amazonaws.util.EC2MetadataUtils;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class Substitutions {
    private String date;
    private String timestamp;
    private String hourlyTimestamp;
    private String startupTimestamp;
    private String pid;
    private String hostname;
    private String sequence;

    public Substitutions(Date curremtDate, int sequence) {
        RuntimeMXBean runtimeMx = ManagementFactory.getRuntimeMXBean();
        String vmName = runtimeMx.getName();
        this.pid = vmName.indexOf(64) > 0 ? vmName.substring(0, vmName.indexOf(64)) : "unknown";
        this.hostname = vmName.indexOf(64) > 0 ? vmName.substring(vmName.indexOf(64) + 1, vmName.length()) : "unknown";
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.date = dateFormat.format(curremtDate);
        SimpleDateFormat timestampFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        timestampFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.timestamp = timestampFormat.format(curremtDate);
        this.hourlyTimestamp = this.timestamp.substring(0, 10) + "0000";
        this.startupTimestamp = timestampFormat.format(new Date(runtimeMx.getStartTime()));
        this.sequence = String.valueOf(sequence);
    }

    public String perform(String input) {
        if (input == null) {
            return "";
        }
        String output = input;
        while (!(output = this.substitute("{date}", this.date, this.substitute("{timestamp}", this.timestamp, this.substitute("{hourlyTimestamp}", this.hourlyTimestamp, this.substitute("{startupTimestamp}", this.startupTimestamp, this.substitute("{pid}", this.pid, this.substitute("{hostname}", this.hostname, this.substitute("{sequence}", this.sequence, this.substituteInstanceId(this.substituteSysprop(this.substituteEnvar(input = output))))))))))).equals(input)) {
        }
        return output;
    }

    private String substitute(String tag, String value, String input) {
        if (input == null) {
            return "";
        }
        if (value == null) {
            return input;
        }
        int index = input.indexOf(tag);
        if (index < 0) {
            return input;
        }
        return input.substring(0, index) + value + input.substring(index + tag.length(), input.length());
    }

    private String substituteInstanceId(String input) {
        int index = input.indexOf("{instanceId}");
        if (index < 0) {
            return input;
        }
        String instanceId = EC2MetadataUtils.getInstanceId();
        if (instanceId == null || instanceId.length() == 0) {
            return input;
        }
        return this.substitute("{instanceId}", instanceId, input);
    }

    private String substituteSysprop(String input) {
        String propName = this.extractPropName("sysprop", input);
        if (propName == null) {
            return input;
        }
        return this.substitute("{sysprop:" + propName + "}", System.getProperty(propName), input);
    }

    private String substituteEnvar(String input) {
        String propName = this.extractPropName("env", input);
        if (propName == null) {
            return input;
        }
        return this.substitute("{env:" + propName + "}", System.getenv(propName), input);
    }

    private String extractPropName(String tagType, String input) {
        String tagForm = "{" + tagType + ":";
        int index1 = input.indexOf(tagForm);
        if (index1 < 0) {
            return null;
        }
        int index2 = input.indexOf("}", index1);
        if (index2 < 0) {
            return null;
        }
        return input.substring(index1 + tagForm.length(), index2);
    }
}

