/*
 * Decompiled with CFR 0.152.
 */
package com.klarna.hiverunner.data;

import com.google.common.base.Splitter;
import com.klarna.hiverunner.data.FileParser;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.hive.hcatalog.data.schema.HCatSchema;

public class TsvFileParser
implements FileParser {
    private static final String DEFAULT_DELIMITER = "\t";
    private static final String DEFAULT_NULL_VALUE = "";
    private Splitter splitter;
    private Object nullValue;
    private Charset charset;

    public TsvFileParser() {
        this.withDelimiter(DEFAULT_DELIMITER);
        this.withNullValue(DEFAULT_NULL_VALUE);
        this.withCharset(StandardCharsets.UTF_8);
    }

    public TsvFileParser withDelimiter(String delimiter) {
        this.splitter = Splitter.on((String)delimiter);
        return this;
    }

    public TsvFileParser withNullValue(Object nullValue) {
        this.nullValue = nullValue;
        return this;
    }

    public TsvFileParser withCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    @Override
    public List<Object[]> parse(File file, HCatSchema schema, List<String> names) {
        try {
            List<String> lines = Files.readAllLines(file.toPath(), this.charset);
            ArrayList<Object[]> records = new ArrayList<Object[]>(lines.size());
            for (String line : lines) {
                records.add(this.parseRow(line, names.size()));
            }
            return records;
        }
        catch (IOException e) {
            throw new RuntimeException("Error while reading file", e);
        }
    }

    private Object[] parseRow(String line, int size) {
        ArrayList<String> row = new ArrayList<String>(size);
        Iterator iterator = this.splitter.split((CharSequence)line).iterator();
        for (int i = 0; i < size; ++i) {
            if (iterator.hasNext()) {
                String column = (String)iterator.next();
                if (ObjectUtils.equals((Object)this.nullValue, (Object)column)) {
                    row.add(null);
                    continue;
                }
                row.add(column);
                continue;
            }
            throw new IllegalStateException("Not enough columns. Require " + size + " columns, got " + i);
        }
        return row.toArray(new Object[size]);
    }
}

