/*
 * Decompiled with CFR 0.152.
 */
package com.klarna.reflection;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Set;

public final class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static void setStaticField(Class clazz, String fieldName, Object value) {
        ReflectionUtils.setField(clazz, null, fieldName, value);
    }

    public static void setField(Object instance, String fieldName, Object value) {
        ReflectionUtils.setField(instance.getClass(), instance, fieldName, value);
    }

    private static void setField(Class clazz, Object instance, String fieldName, Object value) {
        try {
            Field field = clazz.getDeclaredField(fieldName);
            boolean accessible = field.isAccessible();
            field.setAccessible(true);
            field.set(instance, value);
            field.setAccessible(accessible);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException("Failed to set field '" + fieldName + "' on '" + instance + "': " + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Failed to set field '" + fieldName + "' on '" + instance + "': " + e.getMessage(), e);
        }
    }

    public static Set<Field> getAllFields(Class aClass, Predicate<? super Field> predicate) {
        return org.reflections.ReflectionUtils.getAllFields((Class)aClass, predicate);
    }

    public static <T> T getFieldValue(Object testCase, String name, Class<T> type) {
        return ReflectionUtils.getFieldValue(testCase, testCase.getClass(), name, type, false);
    }

    public static <T> T getStaticFieldValue(Class testCaseClass, String name, Class<T> type) {
        return ReflectionUtils.getFieldValue(null, testCaseClass, name, type, true);
    }

    private static <T> T getFieldValue(Object testCase, Class testCaseClass, String name, Class<T> type, boolean isStatic) {
        try {
            Field field = testCaseClass.getDeclaredField(name);
            boolean accessible = field.isAccessible();
            Preconditions.checkState((boolean)field.getType().isAssignableFrom(type), (String)"Field %s must be assignable from ", (Object[])new Object[]{type});
            Preconditions.checkState((!isStatic || Modifier.isStatic(field.getModifiers()) ? 1 : 0) != 0, (String)"Field %s must be static ", (Object[])new Object[]{field});
            field.setAccessible(true);
            Object value = field.get(testCase);
            field.setAccessible(accessible);
            return (T)value;
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException("Failed to lookup field '" + name + "' for '" + testCaseClass + "': " + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Failed to get value of field '" + name + "' for '" + testCaseClass + "': " + e.getMessage(), e);
        }
    }

    public static boolean isOfType(Field setupScriptField, Class type) {
        return setupScriptField.getType().isAssignableFrom(type);
    }
}

