/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.osgi.service.tracker.collections.internal.map;

import com.liferay.osgi.service.tracker.collections.internal.ServiceTrackerUtil;
import com.liferay.osgi.service.tracker.collections.map.KeyedServiceReferenceServiceTuple;
import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerBucket;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerBucketFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.felix.utils.log.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ServiceTrackerMapImpl<K, SR, TS, R>
implements ServiceTrackerMap<K, R> {
    private final Logger _logger;
    private final ServiceReferenceMapper<K, ? super SR> _serviceReferenceMapper;
    private final ServiceTracker<SR, KeyedServiceReferenceServiceTuple<SR, TS, K>> _serviceTracker;
    private final ConcurrentMap<K, ServiceTrackerBucket<SR, TS, R>> _serviceTrackerBuckets = new ConcurrentHashMap<K, ServiceTrackerBucket<SR, TS, R>>();
    private final ServiceTrackerCustomizer<SR, TS> _serviceTrackerCustomizer;
    private final ServiceTrackerBucketFactory<SR, TS, R> _serviceTrackerMapBucketFactory;
    private final ServiceTrackerMapListener<K, TS, R> _serviceTrackerMapListener;

    public ServiceTrackerMapImpl(BundleContext bundleContext, Class<SR> clazz, String filterString, ServiceReferenceMapper<K, ? super SR> serviceReferenceMapper, ServiceTrackerCustomizer<SR, TS> serviceTrackerCustomizer, ServiceTrackerBucketFactory<SR, TS, R> serviceTrackerMapBucketFactory, ServiceTrackerMapListener<K, TS, R> serviceTrackerMapListener) {
        this._serviceReferenceMapper = serviceReferenceMapper;
        this._serviceTrackerCustomizer = serviceTrackerCustomizer;
        this._serviceTrackerMapBucketFactory = serviceTrackerMapBucketFactory;
        this._serviceTrackerMapListener = serviceTrackerMapListener;
        this._serviceTracker = ServiceTrackerUtil.createServiceTracker(bundleContext, clazz, filterString, new ServiceReferenceServiceTrackerCustomizer());
        this._logger = new Logger(bundleContext);
    }

    @Override
    public void close() {
        this._serviceTracker.close();
    }

    @Override
    public boolean containsKey(K key) {
        return this._serviceTrackerBuckets.containsKey(key);
    }

    @Override
    public R getService(K key) {
        ServiceTrackerBucket serviceTrackerBucket = (ServiceTrackerBucket)this._serviceTrackerBuckets.get(key);
        if (serviceTrackerBucket == null) {
            return null;
        }
        return serviceTrackerBucket.getContent();
    }

    @Override
    public Set<K> keySet() {
        return Collections.unmodifiableSet(this._serviceTrackerBuckets.keySet());
    }

    @Override
    public void open() {
        this._serviceTracker.open();
    }

    @Override
    public Collection<R> values() {
        return Collections.unmodifiableCollection(this.getServices());
    }

    protected Collection<R> getServices() {
        ArrayList services = new ArrayList();
        for (ServiceTrackerBucket serviceTrackerBucket : this._serviceTrackerBuckets.values()) {
            services.add(serviceTrackerBucket.getContent());
        }
        return services;
    }

    private void removeKeys(KeyedServiceReferenceServiceTuple<SR, TS, K> keyedServiceReferenceServiceTuple) {
        List<K> emittedKeys = keyedServiceReferenceServiceTuple.getEmittedKeys();
        for (K emittedKey : emittedKeys) {
            ServiceTrackerBucket serviceTrackerBucket = (ServiceTrackerBucket)this._serviceTrackerBuckets.get(emittedKey);
            if (serviceTrackerBucket == null) continue;
            serviceTrackerBucket.remove(keyedServiceReferenceServiceTuple);
            if (serviceTrackerBucket.isDisposable()) {
                this._serviceTrackerBuckets.remove(emittedKey);
            }
            if (this._serviceTrackerMapListener == null) continue;
            try {
                this._serviceTrackerMapListener.keyRemoved(this, emittedKey, keyedServiceReferenceServiceTuple.getService(), serviceTrackerBucket.getContent());
            }
            catch (Throwable t) {
                this._logger.log(1, "Invocation to listener threw exception", t);
            }
        }
        emittedKeys.clear();
    }

    private void storeKey(K key, KeyedServiceReferenceServiceTuple<SR, TS, K> keyedServiceReferenceServiceTuple) {
        ServiceTrackerBucket<SR, TS, R> newServiceTrackerBucket;
        ServiceTrackerBucket<SR, TS, R> serviceTrackerBucket = (ServiceTrackerBucket<SR, TS, R>)this._serviceTrackerBuckets.get(key);
        if (serviceTrackerBucket == null && (serviceTrackerBucket = this._serviceTrackerBuckets.putIfAbsent(key, newServiceTrackerBucket = this._serviceTrackerMapBucketFactory.create())) == null) {
            serviceTrackerBucket = newServiceTrackerBucket;
        }
        serviceTrackerBucket.store(keyedServiceReferenceServiceTuple);
        keyedServiceReferenceServiceTuple.addEmittedKey(key);
    }

    private class ServiceReferenceServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<SR, KeyedServiceReferenceServiceTuple<SR, TS, K>> {
        private ServiceReferenceServiceTrackerCustomizer() {
        }

        public KeyedServiceReferenceServiceTuple<SR, TS, K> addingService(ServiceReference<SR> serviceReference) {
            DefaultEmitter defaultEmitter = new DefaultEmitter(serviceReference);
            ServiceTrackerMapImpl.this._serviceReferenceMapper.map(serviceReference, defaultEmitter);
            return defaultEmitter.getServiceReferenceServiceTuple();
        }

        public void modifiedService(ServiceReference<SR> serviceReference, final KeyedServiceReferenceServiceTuple<SR, TS, K> keyedServiceReferenceServiceTuple) {
            ServiceTrackerMapImpl.this.removeKeys(keyedServiceReferenceServiceTuple);
            ServiceTrackerMapImpl.this._serviceTrackerCustomizer.modifiedService(serviceReference, keyedServiceReferenceServiceTuple.getService());
            ServiceTrackerMapImpl.this._serviceReferenceMapper.map(serviceReference, new ServiceReferenceMapper.Emitter<K>(){

                @Override
                public void emit(K key) {
                    ServiceTrackerMapImpl.this.storeKey(key, keyedServiceReferenceServiceTuple);
                }
            });
        }

        public void removedService(ServiceReference<SR> serviceReference, KeyedServiceReferenceServiceTuple<SR, TS, K> keyedServiceReferenceServiceTuple) {
            ServiceTrackerMapImpl.this.removeKeys(keyedServiceReferenceServiceTuple);
            ServiceTrackerMapImpl.this._serviceTrackerCustomizer.removedService(serviceReference, keyedServiceReferenceServiceTuple.getService());
        }
    }

    private class DefaultEmitter
    implements ServiceReferenceMapper.Emitter<K> {
        private boolean _invokedServiceTrackerCustomizer;
        private KeyedServiceReferenceServiceTuple<SR, TS, K> _keyedServiceReferenceServiceTuple;
        private final ServiceReference<SR> _serviceReference;

        public DefaultEmitter(ServiceReference<SR> serviceReference) {
            this._serviceReference = serviceReference;
        }

        @Override
        public void emit(K key) {
            if (this._keyedServiceReferenceServiceTuple == null && !this._invokedServiceTrackerCustomizer) {
                Object service = ServiceTrackerMapImpl.this._serviceTrackerCustomizer.addingService(this._serviceReference);
                this._invokedServiceTrackerCustomizer = true;
                if (service == null) {
                    return;
                }
                this._keyedServiceReferenceServiceTuple = new KeyedServiceReferenceServiceTuple(this._serviceReference, service);
            }
            ServiceTrackerMapImpl.this.storeKey(key, this._keyedServiceReferenceServiceTuple);
            if (ServiceTrackerMapImpl.this._serviceTrackerMapListener != null) {
                try {
                    ServiceTrackerBucket serviceTrackerBucket = (ServiceTrackerBucket)ServiceTrackerMapImpl.this._serviceTrackerBuckets.get(key);
                    ServiceTrackerMapImpl.this._serviceTrackerMapListener.keyEmitted(ServiceTrackerMapImpl.this, key, this._keyedServiceReferenceServiceTuple.getService(), serviceTrackerBucket.getContent());
                }
                catch (Throwable t) {
                    ServiceTrackerMapImpl.this._logger.log(1, "Invocation to listener threw exception", t);
                }
            }
        }

        public KeyedServiceReferenceServiceTuple<SR, TS, K> getServiceReferenceServiceTuple() {
            return this._keyedServiceReferenceServiceTuple;
        }
    }
}

