/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.osgi.service.tracker.collections.map;

import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ServiceTrackerCustomizerFactory {
    public static <S> ServiceTrackerCustomizer<S, ServiceWrapper<S>> serviceWrapper(final BundleContext bundleContext) {
        return new ServiceTrackerCustomizer<S, ServiceWrapper<S>>(){

            public ServiceWrapper<S> addingService(ServiceReference<S> serviceReference) {
                final Object service = bundleContext.getService(serviceReference);
                if (service == null) {
                    return null;
                }
                try {
                    final Map properties = ServiceTrackerCustomizerFactory._getProperties(serviceReference);
                    return new ServiceWrapper<S>(){

                        @Override
                        public Map<String, Object> getProperties() {
                            return properties;
                        }

                        @Override
                        public S getService() {
                            return service;
                        }
                    };
                }
                catch (Throwable t) {
                    bundleContext.ungetService(serviceReference);
                    throw t;
                }
            }

            public void modifiedService(ServiceReference<S> serviceReference, ServiceWrapper<S> serviceWrapper) {
            }

            public void removedService(ServiceReference<S> serviceReference, ServiceWrapper<S> serviceWrapper) {
                bundleContext.ungetService(serviceReference);
            }
        };
    }

    private static <S> Map<String, Object> _getProperties(ServiceReference<S> serviceReference) {
        String[] propertyKeys;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (String propertyKey : propertyKeys = serviceReference.getPropertyKeys()) {
            properties.put(propertyKey, serviceReference.getProperty(propertyKey));
        }
        return properties;
    }

    public static interface ServiceWrapper<S> {
        public Map<String, Object> getProperties();

        public S getService();
    }
}

