/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.internal.cache.weaklockfree;

import com.microsoft.applicationinsights.agent.shadow.javax.annotation.Nullable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;

abstract class AbstractWeakConcurrentMap<K, V, L>
implements Iterable<Map.Entry<K, V>> {
    private static final ReferenceQueue<Object> REFERENCE_QUEUE = new ReferenceQueue();
    final ConcurrentMap<WeakKey<K>, V> target;
    private final WeakReference<ConcurrentMap<WeakKey<K>, ?>> weakTarget;

    protected AbstractWeakConcurrentMap() {
        this(new ConcurrentHashMap());
    }

    protected AbstractWeakConcurrentMap(ConcurrentMap<WeakKey<K>, V> target) {
        this.target = target;
        this.weakTarget = new WeakReference<ConcurrentMap<WeakKey<WeakKey<K>>, V>>(target);
    }

    protected abstract L getLookupKey(K var1);

    protected abstract void resetLookupKey(L var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key) {
        V previousValue;
        Object value;
        if (key == null) {
            throw new NullPointerException();
        }
        L lookupKey = this.getLookupKey(key);
        try {
            value = this.target.get(lookupKey);
        }
        finally {
            this.resetLookupKey(lookupKey);
        }
        if (value == null && (value = this.defaultValue(key)) != null && (previousValue = this.target.putIfAbsent(new WeakKey<K>(key, this.weakTarget), value)) != null) {
            value = previousValue;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getIfPresent(K key) {
        if (key == null) {
            throw new NullPointerException();
        }
        L lookupKey = this.getLookupKey(key);
        try {
            Object v = this.target.get(lookupKey);
            return v;
        }
        finally {
            this.resetLookupKey(lookupKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(K key) {
        if (key == null) {
            throw new NullPointerException();
        }
        L lookupKey = this.getLookupKey(key);
        try {
            boolean bl = this.target.containsKey(lookupKey);
            return bl;
        }
        finally {
            this.resetLookupKey(lookupKey);
        }
    }

    public V put(K key, V value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        return this.target.put(new WeakKey<K>(key, this.weakTarget), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V putIfAbsent(K key, V value) {
        Object previous;
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        L lookupKey = this.getLookupKey(key);
        try {
            previous = this.target.get(lookupKey);
        }
        finally {
            this.resetLookupKey(lookupKey);
        }
        return previous == null ? this.target.putIfAbsent(new WeakKey<K>(key, this.weakTarget), value) : previous;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        Object previous;
        if (key == null || mappingFunction == null) {
            throw new NullPointerException();
        }
        L lookupKey = this.getLookupKey(key);
        try {
            previous = this.target.get(lookupKey);
        }
        finally {
            this.resetLookupKey(lookupKey);
        }
        return (V)(previous == null ? this.target.computeIfAbsent(new WeakKey<K>(key, this.weakTarget), ignored -> mappingFunction.apply((Object)key)) : previous);
    }

    public V putIfProbablyAbsent(K key, V value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        return this.target.putIfAbsent(new WeakKey<K>(key, this.weakTarget), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(K key) {
        if (key == null) {
            throw new NullPointerException();
        }
        L lookupKey = this.getLookupKey(key);
        try {
            Object v = this.target.remove(lookupKey);
            return v;
        }
        finally {
            this.resetLookupKey(lookupKey);
        }
    }

    public void clear() {
        this.target.clear();
    }

    protected V defaultValue(K key) {
        return null;
    }

    public static void expungeStaleEntries() {
        Reference<Object> reference;
        while ((reference = REFERENCE_QUEUE.poll()) != null) {
            AbstractWeakConcurrentMap.removeWeakKey((WeakKey)reference);
        }
    }

    private static void removeWeakKey(WeakKey<?> weakKey) {
        ConcurrentMap map = (ConcurrentMap)((WeakKey)weakKey).ownerRef.get();
        if (map != null) {
            map.remove(weakKey);
        }
    }

    public int approximateSize() {
        return this.target.size();
    }

    static void runCleanup() {
        try {
            while (!Thread.interrupted()) {
                Reference<Object> reference = REFERENCE_QUEUE.remove();
                if (reference == null) continue;
                AbstractWeakConcurrentMap.removeWeakKey((WeakKey)reference);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return new EntryIterator(this.target.entrySet().iterator());
    }

    public String toString() {
        return this.target.toString();
    }

    static final class WeakKey<K>
    extends WeakReference<K> {
        private final int hashCode;
        private final WeakReference<ConcurrentMap<WeakKey<K>, ?>> ownerRef;

        WeakKey(K key, WeakReference<ConcurrentMap<WeakKey<K>, ?>> ownerRef) {
            super(key, REFERENCE_QUEUE);
            this.hashCode = System.identityHashCode(key);
            this.ownerRef = ownerRef;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(@Nullable Object other) {
            if (other instanceof WeakKey) {
                return ((WeakKey)other).get() == this.get();
            }
            return other.equals(this);
        }

        public String toString() {
            return String.valueOf(this.get());
        }
    }

    private class EntryIterator
    implements Iterator<Map.Entry<K, V>> {
        private final Iterator<Map.Entry<WeakKey<K>, V>> iterator;
        private Map.Entry<WeakKey<K>, V> nextEntry;
        private K nextKey;

        private EntryIterator(Iterator<Map.Entry<WeakKey<K>, V>> iterator) {
            this.iterator = iterator;
            this.findNext();
        }

        private void findNext() {
            while (this.iterator.hasNext()) {
                this.nextEntry = this.iterator.next();
                this.nextKey = this.nextEntry.getKey().get();
                if (this.nextKey == null) continue;
                return;
            }
            this.nextEntry = null;
            this.nextKey = null;
        }

        @Override
        public boolean hasNext() {
            return this.nextKey != null;
        }

        @Override
        public Map.Entry<K, V> next() {
            if (this.nextKey == null) {
                throw new NoSuchElementException();
            }
            try {
                SimpleEntry simpleEntry = new SimpleEntry(this.nextKey, this.nextEntry);
                return simpleEntry;
            }
            finally {
                this.findNext();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class SimpleEntry
    implements Map.Entry<K, V> {
        private final K key;
        final Map.Entry<WeakKey<K>, V> entry;

        private SimpleEntry(K key, Map.Entry<WeakKey<K>, V> entry) {
            this.key = key;
            this.entry = entry;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.entry.getValue();
        }

        @Override
        public V setValue(V value) {
            if (value == null) {
                throw new NullPointerException();
            }
            return this.entry.setValue(value);
        }
    }
}

