/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.function;

import com.azure.resourcemanager.appservice.AppServiceManager;
import com.azure.resourcemanager.appservice.fluent.WebSiteManagementClient;
import com.azure.resourcemanager.appservice.fluent.models.HostKeysInner;
import com.azure.resourcemanager.appservice.models.DeploymentSlotBase;
import com.azure.resourcemanager.appservice.models.FunctionDeploymentSlot;
import com.azure.resourcemanager.appservice.models.FunctionDeploymentSlotBasic;
import com.azure.resourcemanager.appservice.models.PlatformArchitecture;
import com.azure.resourcemanager.appservice.models.WebSiteBase;
import com.microsoft.azure.toolkit.lib.appservice.function.FunctionApp;
import com.microsoft.azure.toolkit.lib.appservice.function.FunctionAppBase;
import com.microsoft.azure.toolkit.lib.appservice.function.FunctionAppDeploymentSlotModule;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class FunctionAppDeploymentSlot
extends FunctionAppBase<FunctionAppDeploymentSlot, FunctionApp, FunctionDeploymentSlot> {
    public static final int MAX_PORT = 65535;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    protected FunctionAppDeploymentSlot(@Nonnull String name, @Nonnull FunctionAppDeploymentSlotModule module) {
        super(name, module);
    }

    protected FunctionAppDeploymentSlot(@Nonnull FunctionAppDeploymentSlot origin) {
        super(origin);
    }

    protected FunctionAppDeploymentSlot(@Nonnull FunctionDeploymentSlotBasic remote, @Nonnull FunctionAppDeploymentSlotModule module) {
        super(remote.name(), module);
    }

    @Nonnull
    public List<AbstractAzResourceModule<?, ?, ?>> getSubModules() {
        return Collections.emptyList();
    }

    @Override
    public String getMasterKey() {
        String name = String.format("%s/slots/%s", ((FunctionApp)this.getParent()).getName(), this.getName());
        return (String)((WebSiteManagementClient)((AppServiceManager)((FunctionDeploymentSlot)this.getFullRemote()).manager()).serviceClient()).getWebApps().listHostKeysAsync(this.getResourceGroupName(), name).map(HostKeysInner::masterKey).block();
    }

    @Override
    @AzureOperation(name="azure/function.enable_remote_debugging.slot", params={"this.getName()"})
    public void enableRemoteDebug() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            Map<String, String> appSettings = this.getAppSettings();
            String debugPort = appSettings.getOrDefault("HTTP_PLATFORM_DEBUG_PORT", this.getRemoteDebugPort());
            this.doModify(() -> (WebSiteBase)((DeploymentSlotBase.Update)((FunctionDeploymentSlot)this.getFullRemote()).update()).withWebSocketsEnabled(true).withPlatformArchitecture(PlatformArchitecture.X64).withAppSetting("HTTP_PLATFORM_DEBUG_PORT", debugPort).withAppSetting("JAVA_OPTS", this.getJavaOptsWithRemoteDebugEnabled(appSettings, debugPort)).apply(), "Updating");
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Override
    @AzureOperation(name="azure/function.disable_remote_debugging.slot", params={"this.getName()"})
    public void disableRemoteDebug() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            Map<String, String> appSettings = this.getAppSettings();
            String javaOpts = this.getJavaOptsWithRemoteDebugDisabled(appSettings);
            this.doModify(() -> {
                if (StringUtils.isEmpty((CharSequence)javaOpts)) {
                    ((DeploymentSlotBase.Update)((FunctionDeploymentSlot)this.getFullRemote()).update()).withoutAppSetting("HTTP_PLATFORM_DEBUG_PORT").withoutAppSetting("JAVA_OPTS").apply();
                } else {
                    ((DeploymentSlotBase.Update)((FunctionDeploymentSlot)this.getFullRemote()).update()).withoutAppSetting("HTTP_PLATFORM_DEBUG_PORT").withAppSetting("JAVA_OPTS", javaOpts).apply();
                }
            }, "Updating");
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Override
    protected String getRemoteDebugPort() {
        List list = ((FunctionApp)this.getParent()).slots().list();
        List collect = list.stream().filter(slot -> slot.getAppSettings().keySet().contains("HTTP_PLATFORM_DEBUG_PORT")).map(slot -> slot.getAppSettings().get("HTTP_PLATFORM_DEBUG_PORT")).map(portValue -> NumberUtils.toInt((String)portValue)).filter(value -> value != 0).collect(Collectors.toList());
        for (int i = Integer.valueOf("8898") + 1; i < 65535; ++i) {
            if (collect.contains(i)) continue;
            return String.valueOf(i);
        }
        throw new AzureToolkitRuntimeException("Could not found free port to enable remote debug.");
    }

    static {
        FunctionAppDeploymentSlot.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("FunctionAppDeploymentSlot.java", FunctionAppDeploymentSlot.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "enableRemoteDebug", "com.microsoft.azure.toolkit.lib.appservice.function.FunctionAppDeploymentSlot", "", "", "", "void"), 58);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "disableRemoteDebug", "com.microsoft.azure.toolkit.lib.appservice.function.FunctionAppDeploymentSlot", "", "", "", "void"), 70);
    }
}

