/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.messager;

import com.microsoft.azure.toolkit.lib.common.messager.IAzureMessage;
import com.microsoft.azure.toolkit.lib.common.messager.IAzureMessager;
import com.microsoft.azure.toolkit.lib.common.operation.OperationContext;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AzureMessager
implements IAzureMessager {
    private static IAzureMessager defaultMessager;

    public static synchronized void setDefaultMessager(@Nonnull IAzureMessager messager) {
        if (defaultMessager == null) {
            defaultMessager = messager;
        } else {
            AzureMessager.getMessager().warning("default messager has already been registered");
        }
    }

    @Nonnull
    public static IAzureMessager getDefaultMessager() {
        return Optional.ofNullable(defaultMessager).orElse(new DummyMessager());
    }

    @Nonnull
    public static IAzureMessager getMessager() {
        return Optional.ofNullable(OperationContext.current()).map(OperationContext::getMessager).orElseGet(AzureMessager::getDefaultMessager);
    }

    public static class DummyMessager
    implements IAzureMessager {
        private static final Logger log = LoggerFactory.getLogger(DummyMessager.class);

        @Override
        public boolean show(IAzureMessage message) {
            log.info("DUMMY MESSAGE:{}", (Object)message);
            return false;
        }
    }
}

