/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.telemetry;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AzureTelemetry {
    public static final String OP_CREATE_AT = "op_create_at";
    public static final String OP_ENTER_AT = "op_enter_at";
    public static final String OP_EXIT_AT = "op_exit_at";

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface Properties {
        public Class<? extends Converter> value() default DefaultConverter.class;

        public static class DefaultConverter
        implements Converter<Object> {
            private static final ObjectMapper objectMapper = new ObjectMapper();
            private static final TypeReference<Map<String, String>> type = new TypeReference<Map<String, String>>(){};

            @Override
            @Nonnull
            public Map<String, String> convert(@Nullable Object obj) {
                return Optional.ofNullable(obj).map(o -> (Map)objectMapper.convertValue(o, type)).orElse(new HashMap());
            }
        }

        public static interface Converter<T> {
            @Nonnull
            public Map<String, String> convert(@Nullable T var1);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface Property {
        public static final String PARAM_NAME = "<param_name>";

        public String value() default "<param_name>";
    }

    public static enum Type {
        OP_START,
        OP_END,
        STEP,
        INFO,
        WARNING,
        ERROR;

    }
}

