/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.flink.writer.internal;

import com.microsoft.azure.flink.common.KustoClientUtil;
import com.microsoft.azure.flink.common.KustoRetryConfig;
import com.microsoft.azure.flink.common.KustoRetryUtil;
import com.microsoft.azure.flink.config.KustoConnectionOptions;
import com.microsoft.azure.kusto.ingest.QueuedIngestClient;
import com.microsoft.azure.kusto.ingest.exceptions.IngestionClientException;
import com.microsoft.azure.kusto.ingest.exceptions.IngestionServiceException;
import com.microsoft.azure.kusto.ingest.resources.ContainerWithSas;
import io.github.resilience4j.retry.Retry;
import java.io.IOException;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.time.Clock;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.util.Preconditions;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
@PublicEvolving
public class ContainerProvider
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerProvider.class);
    private static final long serialVersionUID = 1L;
    private final Random randomGenerator;
    private static final List<ContainerWithSas> CONTAINER_SAS = Collections.synchronizedList(new ArrayList());
    private long expirationTimestamp;
    private final KustoConnectionOptions connectionOptions;
    private final KustoRetryConfig kustoRetryConfig;
    private static ContainerProvider containerProviderInstance;
    private final transient Retry retry;

    private ContainerProvider(KustoConnectionOptions connectionOptions, KustoRetryConfig kustoRetryConfig) {
        this.connectionOptions = connectionOptions;
        this.randomGenerator = new Random();
        this.kustoRetryConfig = kustoRetryConfig;
        this.retry = KustoRetryUtil.getRetries(kustoRetryConfig);
    }

    private static synchronized ContainerProvider build(Builder builder) {
        if (containerProviderInstance == null) {
            containerProviderInstance = new ContainerProvider((KustoConnectionOptions)Preconditions.checkNotNull((Object)builder.connectionOptions), (KustoRetryConfig)Preconditions.checkNotNull((Object)builder.kustoRetryConfig));
        }
        return containerProviderInstance;
    }

    public ContainerWithSas getBlobContainer() {
        if (this.isCacheExpired()) {
            int index = this.randomGenerator.nextInt(CONTAINER_SAS.size());
            LOG.info("Returning storage from cache {}", (Object)CONTAINER_SAS.get(index).getEndpointWithoutSas());
            return CONTAINER_SAS.get(index);
        }
        return (ContainerWithSas)this.retry.executeSupplier(this.getContainerSupplier());
    }

    private boolean isCacheExpired() {
        return this.expirationTimestamp >= Instant.now(Clock.systemUTC()).toEpochMilli() && !CONTAINER_SAS.isEmpty();
    }

    @Contract(pure=true)
    @NotNull
    private Supplier<ContainerWithSas> getContainerSupplier() {
        return () -> {
            try (QueuedIngestClient ingestClient = KustoClientUtil.createDMClient((KustoConnectionOptions)Preconditions.checkNotNull((Object)this.connectionOptions, (String)"Connection options passed to DM client cannot be null."), ContainerProvider.class.getSimpleName());){
                CONTAINER_SAS.clear();
                this.expirationTimestamp = Instant.now(Clock.systemUTC()).plus((long)this.kustoRetryConfig.getCacheExpirationSeconds(), ChronoUnit.SECONDS).toEpochMilli();
                LOG.info("Setting expiration timestamp to {}", (Object)this.expirationTimestamp);
                ingestClient.getResourceManager().getShuffledContainers().forEach(container -> {
                    LOG.debug("Adding container post refresh {}", (Object)container.getEndpointWithoutSas());
                    CONTAINER_SAS.add((ContainerWithSas)container);
                });
                int index = this.randomGenerator.nextInt(CONTAINER_SAS.size());
                ContainerWithSas containerWithSas = CONTAINER_SAS.get(index);
                return containerWithSas;
            }
            catch (IngestionClientException | IngestionServiceException | IOException | URISyntaxException e) {
                LOG.error("Failed to get temp storage container", e);
                if (CONTAINER_SAS.isEmpty()) {
                    throw new RuntimeException(e);
                }
                LOG.warn("Failed to get temp storage container. To cover for transient failures, returning an existing container.If the SAS keys have expired, the flow will fail further in the flow", e);
                int index = this.randomGenerator.nextInt(CONTAINER_SAS.size());
                return CONTAINER_SAS.get(index);
            }
        };
    }

    public long getExpirationTimestamp() {
        return this.expirationTimestamp;
    }

    public static class Builder {
        private final KustoConnectionOptions connectionOptions;
        private final KustoRetryConfig kustoRetryConfig;

        public Builder(@NotNull KustoConnectionOptions connectionOptions) {
            this.connectionOptions = connectionOptions;
            this.kustoRetryConfig = connectionOptions.getKustoRetryConfig();
        }

        public ContainerProvider build() {
            return ContainerProvider.build(this);
        }
    }
}

