/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.flink.writer.internal.sink;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.flink.annotation.Internal;
import org.jetbrains.annotations.NotNull;

@Internal
public class BlobOutputMultiVolume
extends OutputStream {
    private final long maxByteSizePerBlob;
    private long bytesInCurrentVolume = 0L;
    private OutputStream out;
    private final OutputStreamSupplier outputStreamSupplier;

    public BlobOutputMultiVolume(long maxBytePerOutput, @NotNull OutputStreamSupplier outputStreamSupplier) throws IOException {
        this.outputStreamSupplier = outputStreamSupplier;
        this.maxByteSizePerBlob = maxBytePerOutput;
        this.out = outputStreamSupplier.get();
    }

    @Override
    public synchronized void write(byte @NotNull [] bytes) throws IOException {
        int remainingBytesInVol = (int)(this.maxByteSizePerBlob - this.bytesInCurrentVolume);
        if (remainingBytesInVol >= bytes.length) {
            this.out.write(bytes);
            this.bytesInCurrentVolume += (long)bytes.length;
            return;
        }
        this.out.write(bytes, 0, remainingBytesInVol);
        this.switchOutput();
        this.write(bytes, remainingBytesInVol, bytes.length - remainingBytesInVol);
    }

    @Override
    public synchronized void write(int b) throws IOException {
        if (this.bytesInCurrentVolume + 1L <= this.maxByteSizePerBlob) {
            this.out.write(b);
            ++this.bytesInCurrentVolume;
            return;
        }
        this.switchOutput();
        this.out.write(b);
        ++this.bytesInCurrentVolume;
    }

    @Override
    public synchronized void write(byte @NotNull [] b, int off, int len) throws IOException {
        int remainingBytesInVol = (int)(this.maxByteSizePerBlob - this.bytesInCurrentVolume);
        if (remainingBytesInVol >= len) {
            this.out.write(b, off, len);
            this.bytesInCurrentVolume += (long)len;
            return;
        }
        this.out.write(b, off, remainingBytesInVol);
        this.switchOutput();
        this.write(b, off + remainingBytesInVol, len - remainingBytesInVol);
        this.bytesInCurrentVolume += (long)(len - remainingBytesInVol);
    }

    private void switchOutput() throws IOException {
        this.out.flush();
        this.out.close();
        this.out = this.outputStreamSupplier.get();
        this.bytesInCurrentVolume = 0L;
    }

    @Override
    public synchronized void close() throws IOException {
        this.out.close();
    }

    @Override
    public synchronized void flush() throws IOException {
        this.out.flush();
    }

    public static interface OutputStreamSupplier {
        public OutputStream get() throws IOException;
    }
}

