/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.microsoft.azure.kusto.data.Ensure;
import com.microsoft.azure.kusto.data.Utils;
import com.microsoft.azure.kusto.data.format.CslBoolFormat;
import com.microsoft.azure.kusto.data.format.CslDateTimeFormat;
import com.microsoft.azure.kusto.data.format.CslIntFormat;
import com.microsoft.azure.kusto.data.format.CslLongFormat;
import com.microsoft.azure.kusto.data.format.CslRealFormat;
import com.microsoft.azure.kusto.data.format.CslTimespanFormat;
import com.microsoft.azure.kusto.data.format.CslUuidFormat;
import com.microsoft.azure.kusto.data.instrumentation.TraceableAttributes;
import java.io.Serializable;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.ParseException;

public class ClientRequestProperties
implements Serializable,
TraceableAttributes {
    public static final String OPTION_SERVER_TIMEOUT = "servertimeout";
    public static final Pattern KUSTO_TIMESPAN_REGEX = Pattern.compile("(-?)(?:(\\d+)(\\.))?(?:([0-2]?\\d)(:))?([0-5]?\\d)(:)([0-5]?\\d)(?:(\\.)(\\d+))?", 2);
    private static final String OPTIONS_KEY = "Options";
    private static final String PARAMETERS_KEY = "Parameters";
    private final Map<String, Object> parameters = new HashMap<String, Object>();
    private final Map<String, Object> options = new HashMap<String, Object>();
    static final long MAX_TIMEOUT_MS = TimeUnit.HOURS.toMillis(1L);
    private String clientRequestId;
    private String application;
    private String user;

    public void setOption(String name, Object value) {
        this.options.put(name, value);
    }

    public Object getOption(String name) {
        return this.options.get(name);
    }

    public void removeOption(String name) {
        this.options.remove(name);
    }

    public void clearOptions() {
        this.options.clear();
    }

    public void setParameter(String name, Object value) {
        this.parameters.put(name, value);
    }

    public void setParameter(String name, String value) {
        Ensure.stringIsNotBlank(name, "name");
        Ensure.argIsNotNull(value, "value");
        this.parameters.put(name, value);
    }

    public void setParameter(String name, Date value) {
        Ensure.stringIsNotBlank(name, "name");
        Ensure.argIsNotNull(value, "value");
        this.parameters.put(name, new CslDateTimeFormat(value).toString());
    }

    public void setParameter(String name, LocalDateTime value) {
        Ensure.stringIsNotBlank(name, "name");
        Ensure.argIsNotNull(value, "value");
        this.parameters.put(name, new CslDateTimeFormat(value).toString());
    }

    public void setParameter(String name, Duration value) {
        Ensure.stringIsNotBlank(name, "name");
        Ensure.argIsNotNull(value, "value");
        this.parameters.put(name, new CslTimespanFormat(value).toString());
    }

    public void setParameter(String name, boolean value) {
        Ensure.stringIsNotBlank(name, "name");
        this.parameters.put(name, new CslBoolFormat(value).toString());
    }

    public void setParameter(String name, int value) {
        Ensure.stringIsNotBlank(name, "name");
        this.parameters.put(name, new CslIntFormat(value).toString());
    }

    public void setParameter(String name, long value) {
        Ensure.stringIsNotBlank(name, "name");
        this.parameters.put(name, new CslLongFormat(value).toString());
    }

    public void setParameter(String name, double value) {
        Ensure.stringIsNotBlank(name, "name");
        this.parameters.put(name, new CslRealFormat(value).toString());
    }

    public void setParameter(String name, UUID value) {
        Ensure.stringIsNotBlank(name, "name");
        Ensure.argIsNotNull(value, "value");
        this.parameters.put(name, new CslUuidFormat(value).toString());
    }

    public Object getParameter(String name) {
        return this.parameters.get(name);
    }

    public void removeParameter(String name) {
        this.parameters.remove(name);
    }

    public void clearParameters() {
        this.parameters.clear();
    }

    public Long getTimeoutInMilliSec() throws ParseException {
        Object timeoutObj = this.getOption(OPTION_SERVER_TIMEOUT);
        Long timeout = null;
        if (timeoutObj instanceof Long) {
            timeout = (Long)timeoutObj;
        } else if (timeoutObj instanceof String) {
            timeout = this.parseTimeoutFromTimespanString((String)timeoutObj);
        } else if (timeoutObj instanceof Integer) {
            timeout = (long)((Integer)timeoutObj);
        }
        return timeout;
    }

    private long parseTimeoutFromTimespanString(String str) throws ParseException {
        Matcher matcher = KUSTO_TIMESPAN_REGEX.matcher(str);
        if (!matcher.matches()) {
            throw new ParseException(String.format("Failed to parse timeout string as a timespan. Value: '%s'", str));
        }
        if ("-".equals(matcher.group(1))) {
            throw new IllegalArgumentException(String.format("Negative timeouts are invalid. Value: '%s'", str));
        }
        long millis = 0L;
        String days = matcher.group(2);
        if (days != null && !days.equals("0") && !days.equals("00")) {
            return MAX_TIMEOUT_MS;
        }
        String timespanWithoutDays = "";
        for (int i = 4; i <= 10; ++i) {
            if (matcher.group(i) == null) continue;
            timespanWithoutDays = timespanWithoutDays + matcher.group(i);
        }
        return millis += TimeUnit.NANOSECONDS.toMillis(LocalTime.parse(timespanWithoutDays).toNanoOfDay());
    }

    public void setTimeoutInMilliSec(Long timeoutInMs) {
        if (timeoutInMs < 60000L || timeoutInMs > MAX_TIMEOUT_MS) {
            throw new IllegalArgumentException(String.format("Timeout must be between 60,000 and %,d milliseconds", MAX_TIMEOUT_MS));
        }
        this.options.put(OPTION_SERVER_TIMEOUT, timeoutInMs);
    }

    JsonNode toJson() {
        ObjectNode optionsAsJSON = (ObjectNode)Utils.getObjectMapper().valueToTree(this.options);
        Object timeoutObj = this.getOption(OPTION_SERVER_TIMEOUT);
        if (timeoutObj != null) {
            optionsAsJSON.put(OPTION_SERVER_TIMEOUT, this.getTimeoutAsString(timeoutObj));
        }
        ObjectNode json = Utils.getObjectMapper().createObjectNode();
        json.set(OPTIONS_KEY, (JsonNode)optionsAsJSON);
        json.set(PARAMETERS_KEY, Utils.getObjectMapper().valueToTree(this.parameters));
        return json;
    }

    public String toString() {
        return this.toJson().toString();
    }

    public static ClientRequestProperties fromString(String json) throws JsonProcessingException {
        if (StringUtils.isNotBlank((CharSequence)json)) {
            ClientRequestProperties crp = new ClientRequestProperties();
            JsonNode jsonObj = Utils.getObjectMapper().readTree(json);
            Iterator it = jsonObj.fieldNames();
            while (it.hasNext()) {
                String propertyName = (String)it.next();
                if (propertyName.equals(OPTIONS_KEY)) {
                    JsonNode optionsJson = jsonObj.get(propertyName);
                    Iterator optionsIt = optionsJson.fieldNames();
                    while (optionsIt.hasNext()) {
                        String optionName = (String)optionsIt.next();
                        crp.setOption(optionName, optionsJson.get(optionName).asText());
                    }
                    continue;
                }
                if (!propertyName.equals(PARAMETERS_KEY)) continue;
                JsonNode parameters = jsonObj.get(propertyName);
                Iterator parametersIt = parameters.fieldNames();
                while (parametersIt.hasNext()) {
                    String parameterName = (String)parametersIt.next();
                    crp.setParameter(parameterName, parameters.get(parameterName).asText());
                }
            }
            return crp;
        }
        return null;
    }

    public String getClientRequestId() {
        return this.clientRequestId;
    }

    public void setClientRequestId(String clientRequestId) {
        this.clientRequestId = clientRequestId;
    }

    public String getApplication() {
        return this.application;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    Iterator<Map.Entry<String, Object>> getOptions() {
        return this.options.entrySet().iterator();
    }

    @Override
    public Map<String, String> getTracingAttributes() {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("clientRequestId", this.getClientRequestId());
        return attributes;
    }

    String getTimeoutAsString(Object timeoutObj) {
        String timeoutString = "";
        if (timeoutObj instanceof Long) {
            Duration duration = Duration.ofMillis((Long)timeoutObj);
            timeoutString = Utils.formatDurationAsTimespan(duration);
        } else if (timeoutObj instanceof String) {
            timeoutString = (String)timeoutObj;
        } else if (timeoutObj instanceof Integer) {
            Duration duration = Duration.ofMillis(((Integer)timeoutObj).intValue());
            timeoutString = Utils.formatDurationAsTimespan(duration);
        }
        return timeoutString;
    }
}

