/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.ingest;

import com.microsoft.azure.kusto.ingest.ColumnMapping;
import java.util.Arrays;

public class IngestionMapping {
    private ColumnMapping[] columnMappings;
    private IngestionMappingKind ingestionMappingKind;
    private String ingestionMappingReference;

    public IngestionMapping() {
    }

    public IngestionMapping(String ingestionMappingReference, IngestionMappingKind ingestionMappingKind) {
        this.ingestionMappingReference = ingestionMappingReference;
        this.ingestionMappingKind = ingestionMappingKind;
    }

    public IngestionMapping(ColumnMapping[] columnMappings, IngestionMappingKind ingestionMappingKind) {
        this.columnMappings = columnMappings;
        this.ingestionMappingKind = ingestionMappingKind;
    }

    public IngestionMapping(IngestionMapping other) {
        this.ingestionMappingKind = other.ingestionMappingKind;
        this.ingestionMappingReference = other.ingestionMappingReference;
        if (other.columnMappings != null) {
            this.columnMappings = (ColumnMapping[])Arrays.stream(other.columnMappings).map(ColumnMapping::new).toArray(ColumnMapping[]::new);
        }
    }

    public void setIngestionMappingReference(String ingestionMappingReference, IngestionMappingKind ingestionMappingKind) {
        this.ingestionMappingReference = ingestionMappingReference;
        this.ingestionMappingKind = ingestionMappingKind;
    }

    public void setIngestionMapping(ColumnMapping[] columnMappings, IngestionMappingKind ingestionMappingKind) {
        this.columnMappings = columnMappings;
        this.ingestionMappingKind = ingestionMappingKind;
    }

    public IngestionMappingKind getIngestionMappingKind() {
        return this.ingestionMappingKind;
    }

    public String getIngestionMappingReference() {
        return this.ingestionMappingReference;
    }

    public ColumnMapping[] getColumnMappings() {
        return this.columnMappings;
    }

    public static enum IngestionMappingKind {
        CSV("Csv"),
        JSON("Json"),
        AVRO("Avro"),
        PARQUET("Parquet"),
        SSTREAM("SStream"),
        ORC("Orc"),
        APACHEAVRO("ApacheAvro"),
        W3CLOGFILE("W3CLogFile");

        private final String kustoValue;

        private IngestionMappingKind(String kustoValue) {
            this.kustoValue = kustoValue;
        }

        public String getKustoValue() {
            return this.kustoValue;
        }
    }
}

