/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.auth.confidentialClient;

import com.microsoft.graph.auth.BaseAuthentication;
import com.microsoft.graph.auth.enums.NationalCloud;
import com.microsoft.graph.authentication.IAuthenticationProvider;
import com.microsoft.graph.http.IHttpRequest;
import com.microsoft.graph.httpcore.ICoreAuthenticationProvider;
import java.util.List;
import okhttp3.Request;
import org.apache.oltu.oauth2.client.HttpClient;
import org.apache.oltu.oauth2.client.OAuthClient;
import org.apache.oltu.oauth2.client.URLConnectionClient;
import org.apache.oltu.oauth2.client.request.OAuthClientRequest;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.apache.oltu.oauth2.common.message.types.GrantType;

public class ClientCredentialProvider
extends BaseAuthentication
implements IAuthenticationProvider,
ICoreAuthenticationProvider {
    public ClientCredentialProvider(String clientId, List<String> scopes, String clientSecret, String tenant, NationalCloud nationalCloud) {
        super(scopes, clientId, ClientCredentialProvider.GetAuthority(nationalCloud == null ? NationalCloud.Global : nationalCloud, tenant), null, nationalCloud == null ? NationalCloud.Global : nationalCloud, tenant, clientSecret);
    }

    public void authenticateRequest(IHttpRequest request) {
        String accessToken = this.getAcccessToken();
        request.addHeader("Authorization", "Bearer " + accessToken);
    }

    public Request authenticateRequest(Request request) {
        String accessToken = this.getAcccessToken();
        return request.newBuilder().addHeader("Authorization", "Bearer " + accessToken).build();
    }

    String getAcccessToken() {
        String accessToken = "";
        try {
            long duration = System.currentTimeMillis() - this.getStartTime();
            if (this.getResponse() != null && duration > 0L && duration < this.getResponse().getExpiresIn() * 1000L) {
                accessToken = this.getResponse().getAccessToken();
            } else {
                OAuthClientRequest authRequest = this.getTokenRequestMessage();
                accessToken = this.getAccessTokenNewRequest(authRequest);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return accessToken;
    }

    OAuthClientRequest getTokenRequestMessage() throws OAuthSystemException {
        String tokenUrl = this.getAuthority() + "/oauth2/v2.0/token";
        OAuthClientRequest.TokenRequestBuilder token = OAuthClientRequest.tokenLocation((String)tokenUrl).setClientId(this.getClientId()).setGrantType(GrantType.CLIENT_CREDENTIALS).setScope(this.getScopesAsString());
        if (this.getClientSecret() != null) {
            token.setClientSecret(this.getClientSecret());
        }
        return token.buildBodyMessage();
    }

    String getAccessTokenNewRequest(OAuthClientRequest request) throws OAuthSystemException, OAuthProblemException {
        OAuthClient oAuthClient = new OAuthClient((HttpClient)new URLConnectionClient());
        this.setStartTime(System.currentTimeMillis());
        this.setResponse(oAuthClient.accessToken(request));
        return this.getResponse().getAccessToken();
    }
}

