// Template Source: IBaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.callrecords.requests.extensions;
import com.microsoft.graph.callrecords.models.extensions.Session;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Session Request.
 */
public interface ISessionRequest extends IHttpRequest {

    /**
     * Gets the Session from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super Session> callback);

    /**
     * Gets the Session from the service
     *
     * @return the Session from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Session get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super Session> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this Session with a source
     *
     * @param sourceSession the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final Session sourceSession, final ICallback<? super Session> callback);

    /**
     * Patches this Session with a source
     *
     * @param sourceSession the source object with updates
     * @return the updated Session
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Session patch(final Session sourceSession) throws ClientException;

    /**
     * Posts a Session with a new object
     *
     * @param newSession the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final Session newSession, final ICallback<? super Session> callback);

    /**
     * Posts a Session with a new object
     *
     * @param newSession the new object to create
     * @return the created Session
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Session post(final Session newSession) throws ClientException;

    /**
     * Posts a Session with a new object
     *
     * @param newSession the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final Session newSession, final ICallback<? super Session> callback);

    /**
     * Posts a Session with a new object
     *
     * @param newSession the object to create/update
     * @return the created Session
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Session put(final Session newSession) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    ISessionRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    ISessionRequest expand(final String value);

}

