// Template Source: IBaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.SearchEntity;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Search Entity Request.
 */
public interface ISearchEntityRequest extends IHttpRequest {

    /**
     * Gets the SearchEntity from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super SearchEntity> callback);

    /**
     * Gets the SearchEntity from the service
     *
     * @return the SearchEntity from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    SearchEntity get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super SearchEntity> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this SearchEntity with a source
     *
     * @param sourceSearchEntity the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final SearchEntity sourceSearchEntity, final ICallback<? super SearchEntity> callback);

    /**
     * Patches this SearchEntity with a source
     *
     * @param sourceSearchEntity the source object with updates
     * @return the updated SearchEntity
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    SearchEntity patch(final SearchEntity sourceSearchEntity) throws ClientException;

    /**
     * Posts a SearchEntity with a new object
     *
     * @param newSearchEntity the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final SearchEntity newSearchEntity, final ICallback<? super SearchEntity> callback);

    /**
     * Posts a SearchEntity with a new object
     *
     * @param newSearchEntity the new object to create
     * @return the created SearchEntity
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    SearchEntity post(final SearchEntity newSearchEntity) throws ClientException;

    /**
     * Posts a SearchEntity with a new object
     *
     * @param newSearchEntity the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final SearchEntity newSearchEntity, final ICallback<? super SearchEntity> callback);

    /**
     * Posts a SearchEntity with a new object
     *
     * @param newSearchEntity the object to create/update
     * @return the created SearchEntity
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    SearchEntity put(final SearchEntity newSearchEntity) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    ISearchEntityRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    ISearchEntityRequest expand(final String value);

}

