// Template Source: IBaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.TermsOfUseContainer;
import com.microsoft.graph.requests.extensions.IAgreementAcceptanceCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IAgreementAcceptanceRequestBuilder;
import com.microsoft.graph.requests.extensions.IAgreementCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IAgreementRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Terms Of Use Container Request Builder.
 */
public interface ITermsOfUseContainerRequestBuilder extends IRequestBuilder {
    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the ITermsOfUseContainerRequest instance
     */
    ITermsOfUseContainerRequest buildRequest(final com.microsoft.graph.options.Option... requestOptions);

    /**
     * Creates the request with specific options instead of the existing options
     *
     * @param requestOptions the options for this request
     * @return the ITermsOfUseContainerRequest instance
     */
    ITermsOfUseContainerRequest buildRequest(final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions);


    IAgreementAcceptanceCollectionRequestBuilder agreementAcceptances();

    IAgreementAcceptanceRequestBuilder agreementAcceptances(final String id);

    IAgreementCollectionRequestBuilder agreements();

    IAgreementRequestBuilder agreements(final String id);

}