/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.DeviceConfigurationDeviceStatus;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.DeviceConfigurationDeviceStatusCollectionPage;
import com.microsoft.graph.requests.extensions.DeviceConfigurationDeviceStatusCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.DeviceConfigurationDeviceStatusCollectionResponse;
import com.microsoft.graph.requests.extensions.DeviceConfigurationDeviceStatusRequestBuilder;
import com.microsoft.graph.requests.extensions.IDeviceConfigurationDeviceStatusCollectionPage;
import com.microsoft.graph.requests.extensions.IDeviceConfigurationDeviceStatusCollectionRequest;
import java.util.List;

public class DeviceConfigurationDeviceStatusCollectionRequest
extends BaseCollectionRequest<DeviceConfigurationDeviceStatusCollectionResponse, IDeviceConfigurationDeviceStatusCollectionPage>
implements IDeviceConfigurationDeviceStatusCollectionRequest {
    public DeviceConfigurationDeviceStatusCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, DeviceConfigurationDeviceStatusCollectionResponse.class, IDeviceConfigurationDeviceStatusCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IDeviceConfigurationDeviceStatusCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(DeviceConfigurationDeviceStatusCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDeviceConfigurationDeviceStatusCollectionPage get() throws ClientException {
        DeviceConfigurationDeviceStatusCollectionResponse response = (DeviceConfigurationDeviceStatusCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(DeviceConfigurationDeviceStatus newDeviceConfigurationDeviceStatus, ICallback<? super DeviceConfigurationDeviceStatus> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new DeviceConfigurationDeviceStatusRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newDeviceConfigurationDeviceStatus, callback);
    }

    @Override
    public DeviceConfigurationDeviceStatus post(DeviceConfigurationDeviceStatus newDeviceConfigurationDeviceStatus) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new DeviceConfigurationDeviceStatusRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newDeviceConfigurationDeviceStatus);
    }

    @Override
    public IDeviceConfigurationDeviceStatusCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IDeviceConfigurationDeviceStatusCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IDeviceConfigurationDeviceStatusCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IDeviceConfigurationDeviceStatusCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IDeviceConfigurationDeviceStatusCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IDeviceConfigurationDeviceStatusCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IDeviceConfigurationDeviceStatusCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IDeviceConfigurationDeviceStatusCollectionPage buildFromResponse(DeviceConfigurationDeviceStatusCollectionResponse response) {
        DeviceConfigurationDeviceStatusCollectionRequestBuilder builder = response.nextLink != null ? new DeviceConfigurationDeviceStatusCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        DeviceConfigurationDeviceStatusCollectionPage page = new DeviceConfigurationDeviceStatusCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

