/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.PrintDocument;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IPrintDocumentRequest;
import java.util.List;

public class PrintDocumentRequest
extends BaseRequest
implements IPrintDocumentRequest {
    public PrintDocumentRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, PrintDocument.class);
    }

    @Override
    public void get(ICallback<? super PrintDocument> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public PrintDocument get() throws ClientException {
        return (PrintDocument)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<? super PrintDocument> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(PrintDocument sourcePrintDocument, ICallback<? super PrintDocument> callback) {
        this.send(HttpMethod.PATCH, callback, sourcePrintDocument);
    }

    @Override
    public PrintDocument patch(PrintDocument sourcePrintDocument) throws ClientException {
        return (PrintDocument)this.send(HttpMethod.PATCH, sourcePrintDocument);
    }

    @Override
    public void post(PrintDocument newPrintDocument, ICallback<? super PrintDocument> callback) {
        this.send(HttpMethod.POST, callback, newPrintDocument);
    }

    @Override
    public PrintDocument post(PrintDocument newPrintDocument) throws ClientException {
        return (PrintDocument)this.send(HttpMethod.POST, newPrintDocument);
    }

    @Override
    public void put(PrintDocument newPrintDocument, ICallback<? super PrintDocument> callback) {
        this.send(HttpMethod.PUT, callback, newPrintDocument);
    }

    @Override
    public PrintDocument put(PrintDocument newPrintDocument) throws ClientException {
        return (PrintDocument)this.send(HttpMethod.PUT, newPrintDocument);
    }

    @Override
    public IPrintDocumentRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IPrintDocumentRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }
}

