/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.PrintOperation;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IPrintOperationCollectionPage;
import com.microsoft.graph.requests.extensions.IPrintOperationCollectionRequest;
import com.microsoft.graph.requests.extensions.PrintOperationCollectionPage;
import com.microsoft.graph.requests.extensions.PrintOperationCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.PrintOperationCollectionResponse;
import com.microsoft.graph.requests.extensions.PrintOperationRequestBuilder;
import java.util.List;

public class PrintOperationCollectionRequest
extends BaseCollectionRequest<PrintOperationCollectionResponse, IPrintOperationCollectionPage>
implements IPrintOperationCollectionRequest {
    public PrintOperationCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, PrintOperationCollectionResponse.class, IPrintOperationCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IPrintOperationCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(PrintOperationCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IPrintOperationCollectionPage get() throws ClientException {
        PrintOperationCollectionResponse response = (PrintOperationCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(PrintOperation newPrintOperation, ICallback<? super PrintOperation> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new PrintOperationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newPrintOperation, callback);
    }

    @Override
    public PrintOperation post(PrintOperation newPrintOperation) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new PrintOperationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newPrintOperation);
    }

    @Override
    public IPrintOperationCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IPrintOperationCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IPrintOperationCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IPrintOperationCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IPrintOperationCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IPrintOperationCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IPrintOperationCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IPrintOperationCollectionPage buildFromResponse(PrintOperationCollectionResponse response) {
        PrintOperationCollectionRequestBuilder builder = response.nextLink != null ? new PrintOperationCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        PrintOperationCollectionPage page = new PrintOperationCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

