// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.BroadcastMeetingAudience;
import com.microsoft.graph.models.BroadcastMeetingCaptionSettings;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Broadcast Meeting Settings.
 */
public class BroadcastMeetingSettings implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Allowed Audience.
     * Defines who can join the Teams live event. Possible values are listed in the following table.
     */
    @SerializedName(value = "allowedAudience", alternate = {"AllowedAudience"})
    @Expose
	@Nullable
    public BroadcastMeetingAudience allowedAudience;

    /**
     * The Captions.
     * Caption settings of a Teams live event.
     */
    @SerializedName(value = "captions", alternate = {"Captions"})
    @Expose
	@Nullable
    public BroadcastMeetingCaptionSettings captions;

    /**
     * The Is Attendee Report Enabled.
     * Indicates whether attendee report is enabled for this Teams live event. Default value is false.
     */
    @SerializedName(value = "isAttendeeReportEnabled", alternate = {"IsAttendeeReportEnabled"})
    @Expose
	@Nullable
    public Boolean isAttendeeReportEnabled;

    /**
     * The Is Question And Answer Enabled.
     * Indicates whether Q&amp;A is enabled for this Teams live event. Default value is false.
     */
    @SerializedName(value = "isQuestionAndAnswerEnabled", alternate = {"IsQuestionAndAnswerEnabled"})
    @Expose
	@Nullable
    public Boolean isQuestionAndAnswerEnabled;

    /**
     * The Is Recording Enabled.
     * Indicates whether recording is enabled for this Teams live event. Default value is false.
     */
    @SerializedName(value = "isRecordingEnabled", alternate = {"IsRecordingEnabled"})
    @Expose
	@Nullable
    public Boolean isRecordingEnabled;

    /**
     * The Is Video On Demand Enabled.
     * Indicates whether video on demand is enabled for this Teams live event. Default value is false.
     */
    @SerializedName(value = "isVideoOnDemandEnabled", alternate = {"IsVideoOnDemandEnabled"})
    @Expose
	@Nullable
    public Boolean isVideoOnDemandEnabled;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
