// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;


import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Content Type Associate With Hub Sites Parameter Set.
 */
public class ContentTypeAssociateWithHubSitesParameterSet {
    /**
     * The hub Site Urls.
     * 
     */
    @SerializedName(value = "hubSiteUrls", alternate = {"HubSiteUrls"})
    @Expose
	@Nullable
    public java.util.List<String> hubSiteUrls;

    /**
     * The propagate To Existing Lists.
     * 
     */
    @SerializedName(value = "propagateToExistingLists", alternate = {"PropagateToExistingLists"})
    @Expose
	@Nullable
    public Boolean propagateToExistingLists;


    /**
     * Instiaciates a new ContentTypeAssociateWithHubSitesParameterSet
     */
    public ContentTypeAssociateWithHubSitesParameterSet() {}
    /**
     * Instiaciates a new ContentTypeAssociateWithHubSitesParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected ContentTypeAssociateWithHubSitesParameterSet(@Nonnull final ContentTypeAssociateWithHubSitesParameterSetBuilder builder) {
        this.hubSiteUrls = builder.hubSiteUrls;
        this.propagateToExistingLists = builder.propagateToExistingLists;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static ContentTypeAssociateWithHubSitesParameterSetBuilder newBuilder() {
        return new ContentTypeAssociateWithHubSitesParameterSetBuilder();
    }
    /**
     * Fluent builder for the ContentTypeAssociateWithHubSitesParameterSet
     */
    public static final class ContentTypeAssociateWithHubSitesParameterSetBuilder {
        /**
         * The hubSiteUrls parameter value
         */
        @Nullable
        protected java.util.List<String> hubSiteUrls;
        /**
         * Sets the HubSiteUrls
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public ContentTypeAssociateWithHubSitesParameterSetBuilder withHubSiteUrls(@Nullable final java.util.List<String> val) {
            this.hubSiteUrls = val;
            return this;
        }
        /**
         * The propagateToExistingLists parameter value
         */
        @Nullable
        protected Boolean propagateToExistingLists;
        /**
         * Sets the PropagateToExistingLists
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public ContentTypeAssociateWithHubSitesParameterSetBuilder withPropagateToExistingLists(@Nullable final Boolean val) {
            this.propagateToExistingLists = val;
            return this;
        }
        /**
         * Instanciates a new ContentTypeAssociateWithHubSitesParameterSetBuilder
         */
        @Nullable
        protected ContentTypeAssociateWithHubSitesParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public ContentTypeAssociateWithHubSitesParameterSet build() {
            return new ContentTypeAssociateWithHubSitesParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.hubSiteUrls != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("hubSiteUrls", hubSiteUrls));
        }
        if(this.propagateToExistingLists != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("propagateToExistingLists", propagateToExistingLists));
        }
        return result;
    }
}
