// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.DelegatedAdminAccessContainer;
import com.microsoft.graph.models.DelegatedAdminAccessDetails;
import com.microsoft.graph.models.DelegatedAdminAccessAssignmentStatus;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Delegated Admin Access Assignment.
 */
public class DelegatedAdminAccessAssignment extends Entity implements IJsonBackedObject {


    /**
     * The Access Container.
     * The access container through which members are assigned access. For example, a security group.
     */
    @SerializedName(value = "accessContainer", alternate = {"AccessContainer"})
    @Expose
	@Nullable
    public DelegatedAdminAccessContainer accessContainer;

    /**
     * The Access Details.
     * The access details containing the identifiers of the administrative roles that the partner is assigned in the customer tenant.
     */
    @SerializedName(value = "accessDetails", alternate = {"AccessDetails"})
    @Expose
	@Nullable
    public DelegatedAdminAccessDetails accessDetails;

    /**
     * The Created Date Time.
     * The date and time in ISO 8601 format and in UTC time when the access assignment was created. Read-only.
     */
    @SerializedName(value = "createdDateTime", alternate = {"CreatedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime createdDateTime;

    /**
     * The Last Modified Date Time.
     * The date and time in ISO 8601 and in UTC time when this access assignment was last modified. Read-only.
     */
    @SerializedName(value = "lastModifiedDateTime", alternate = {"LastModifiedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime lastModifiedDateTime;

    /**
     * The Status.
     * The status of the access assignment. Read-only. The possible values are: pending, active, deleting, deleted, error, unknownFutureValue.
     */
    @SerializedName(value = "status", alternate = {"Status"})
    @Expose
	@Nullable
    public DelegatedAdminAccessAssignmentStatus status;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
