// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.OnenoteOperation;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Onenote Page Copy To Section Parameter Set.
 */
public class OnenotePageCopyToSectionParameterSet {
    /**
     * The id.
     * 
     */
    @SerializedName(value = "id", alternate = {"Id"})
    @Expose
	@Nullable
    public String id;

    /**
     * The group Id.
     * 
     */
    @SerializedName(value = "groupId", alternate = {"GroupId"})
    @Expose
	@Nullable
    public String groupId;

    /**
     * The site Collection Id.
     * 
     */
    @SerializedName(value = "siteCollectionId", alternate = {"SiteCollectionId"})
    @Expose
	@Nullable
    public String siteCollectionId;

    /**
     * The site Id.
     * 
     */
    @SerializedName(value = "siteId", alternate = {"SiteId"})
    @Expose
	@Nullable
    public String siteId;


    /**
     * Instiaciates a new OnenotePageCopyToSectionParameterSet
     */
    public OnenotePageCopyToSectionParameterSet() {}
    /**
     * Instiaciates a new OnenotePageCopyToSectionParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected OnenotePageCopyToSectionParameterSet(@Nonnull final OnenotePageCopyToSectionParameterSetBuilder builder) {
        this.id = builder.id;
        this.groupId = builder.groupId;
        this.siteCollectionId = builder.siteCollectionId;
        this.siteId = builder.siteId;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static OnenotePageCopyToSectionParameterSetBuilder newBuilder() {
        return new OnenotePageCopyToSectionParameterSetBuilder();
    }
    /**
     * Fluent builder for the OnenotePageCopyToSectionParameterSet
     */
    public static final class OnenotePageCopyToSectionParameterSetBuilder {
        /**
         * The id parameter value
         */
        @Nullable
        protected String id;
        /**
         * Sets the Id
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public OnenotePageCopyToSectionParameterSetBuilder withId(@Nullable final String val) {
            this.id = val;
            return this;
        }
        /**
         * The groupId parameter value
         */
        @Nullable
        protected String groupId;
        /**
         * Sets the GroupId
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public OnenotePageCopyToSectionParameterSetBuilder withGroupId(@Nullable final String val) {
            this.groupId = val;
            return this;
        }
        /**
         * The siteCollectionId parameter value
         */
        @Nullable
        protected String siteCollectionId;
        /**
         * Sets the SiteCollectionId
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public OnenotePageCopyToSectionParameterSetBuilder withSiteCollectionId(@Nullable final String val) {
            this.siteCollectionId = val;
            return this;
        }
        /**
         * The siteId parameter value
         */
        @Nullable
        protected String siteId;
        /**
         * Sets the SiteId
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public OnenotePageCopyToSectionParameterSetBuilder withSiteId(@Nullable final String val) {
            this.siteId = val;
            return this;
        }
        /**
         * Instanciates a new OnenotePageCopyToSectionParameterSetBuilder
         */
        @Nullable
        protected OnenotePageCopyToSectionParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public OnenotePageCopyToSectionParameterSet build() {
            return new OnenotePageCopyToSectionParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.id != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("id", id));
        }
        if(this.groupId != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("groupId", groupId));
        }
        if(this.siteCollectionId != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("siteCollectionId", siteCollectionId));
        }
        if(this.siteId != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("siteId", siteId));
        }
        return result;
    }
}
