// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.AuthenticationProtocol;
import com.microsoft.graph.models.IdentityProviderBase;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Saml Or Ws Fed Provider.
 */
public class SamlOrWsFedProvider extends IdentityProviderBase implements IJsonBackedObject {


    /**
     * The Issuer Uri.
     * Issuer URI of the federation server.
     */
    @SerializedName(value = "issuerUri", alternate = {"IssuerUri"})
    @Expose
	@Nullable
    public String issuerUri;

    /**
     * The Metadata Exchange Uri.
     * URI of the metadata exchange endpoint used for authentication from rich client applications.
     */
    @SerializedName(value = "metadataExchangeUri", alternate = {"MetadataExchangeUri"})
    @Expose
	@Nullable
    public String metadataExchangeUri;

    /**
     * The Passive Sign In Uri.
     * URI that web-based clients are directed to when signing in to Azure Active Directory (Azure AD) services.
     */
    @SerializedName(value = "passiveSignInUri", alternate = {"PassiveSignInUri"})
    @Expose
	@Nullable
    public String passiveSignInUri;

    /**
     * The Preferred Authentication Protocol.
     * Preferred authentication protocol. The possible values are: wsFed, saml, unknownFutureValue.
     */
    @SerializedName(value = "preferredAuthenticationProtocol", alternate = {"PreferredAuthenticationProtocol"})
    @Expose
	@Nullable
    public AuthenticationProtocol preferredAuthenticationProtocol;

    /**
     * The Signing Certificate.
     * Current certificate used to sign tokens passed to the Microsoft identity platform. The certificate is formatted as a Base64 encoded string of the public portion of the federated IdP's token signing certificate and must be compatible with the X509Certificate2 class.   This property is used in the following scenarios:  if a rollover is required outside of the autorollover update a new federation service is being set up  if the new token signing certificate isn't present in the federation properties after the federation service certificate has been updated.   Azure AD updates certificates via an autorollover process in which it attempts to retrieve a new certificate from the federation service metadata, 30 days before expiry of the current certificate. If a new certificate isn't available, Azure AD monitors the metadata daily and will update the federation settings for the domain when a new certificate is available.
     */
    @SerializedName(value = "signingCertificate", alternate = {"SigningCertificate"})
    @Expose
	@Nullable
    public String signingCertificate;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
