// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.ContentType;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Site Get Applicable Content Types For List Parameter Set.
 */
public class SiteGetApplicableContentTypesForListParameterSet {
    /**
     * The list Id.
     * 
     */
    @SerializedName(value = "listId", alternate = {"ListId"})
    @Expose
	@Nullable
    public String listId;


    /**
     * Instiaciates a new SiteGetApplicableContentTypesForListParameterSet
     */
    public SiteGetApplicableContentTypesForListParameterSet() {}
    /**
     * Instiaciates a new SiteGetApplicableContentTypesForListParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected SiteGetApplicableContentTypesForListParameterSet(@Nonnull final SiteGetApplicableContentTypesForListParameterSetBuilder builder) {
        this.listId = builder.listId;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static SiteGetApplicableContentTypesForListParameterSetBuilder newBuilder() {
        return new SiteGetApplicableContentTypesForListParameterSetBuilder();
    }
    /**
     * Fluent builder for the SiteGetApplicableContentTypesForListParameterSet
     */
    public static final class SiteGetApplicableContentTypesForListParameterSetBuilder {
        /**
         * The listId parameter value
         */
        @Nullable
        protected String listId;
        /**
         * Sets the ListId
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public SiteGetApplicableContentTypesForListParameterSetBuilder withListId(@Nullable final String val) {
            this.listId = val;
            return this;
        }
        /**
         * Instanciates a new SiteGetApplicableContentTypesForListParameterSetBuilder
         */
        @Nullable
        protected SiteGetApplicableContentTypesForListParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public SiteGetApplicableContentTypesForListParameterSet build() {
            return new SiteGetApplicableContentTypesForListParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.listId != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("listId", listId));
        }
        return result;
    }
}
