// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.AssignedTrainingInfo;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Training Events Content.
 */
public class TrainingEventsContent implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Assigned Trainings Infos.
     * List of assigned trainings and their information in an attack simulation and training campaign.
     */
    @SerializedName(value = "assignedTrainingsInfos", alternate = {"AssignedTrainingsInfos"})
    @Expose
	@Nullable
    public java.util.List<AssignedTrainingInfo> assignedTrainingsInfos;

    /**
     * The Trainings Assigned User Count.
     * Number of users who were assigned trainings in an attack simulation and training campaign.
     */
    @SerializedName(value = "trainingsAssignedUserCount", alternate = {"TrainingsAssignedUserCount"})
    @Expose
	@Nullable
    public Integer trainingsAssignedUserCount;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
