// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;


import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the User Wipe Managed App Registrations By Device Tag Parameter Set.
 */
public class UserWipeManagedAppRegistrationsByDeviceTagParameterSet {
    /**
     * The device Tag.
     * 
     */
    @SerializedName(value = "deviceTag", alternate = {"DeviceTag"})
    @Expose
	@Nullable
    public String deviceTag;


    /**
     * Instiaciates a new UserWipeManagedAppRegistrationsByDeviceTagParameterSet
     */
    public UserWipeManagedAppRegistrationsByDeviceTagParameterSet() {}
    /**
     * Instiaciates a new UserWipeManagedAppRegistrationsByDeviceTagParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected UserWipeManagedAppRegistrationsByDeviceTagParameterSet(@Nonnull final UserWipeManagedAppRegistrationsByDeviceTagParameterSetBuilder builder) {
        this.deviceTag = builder.deviceTag;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static UserWipeManagedAppRegistrationsByDeviceTagParameterSetBuilder newBuilder() {
        return new UserWipeManagedAppRegistrationsByDeviceTagParameterSetBuilder();
    }
    /**
     * Fluent builder for the UserWipeManagedAppRegistrationsByDeviceTagParameterSet
     */
    public static final class UserWipeManagedAppRegistrationsByDeviceTagParameterSetBuilder {
        /**
         * The deviceTag parameter value
         */
        @Nullable
        protected String deviceTag;
        /**
         * Sets the DeviceTag
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public UserWipeManagedAppRegistrationsByDeviceTagParameterSetBuilder withDeviceTag(@Nullable final String val) {
            this.deviceTag = val;
            return this;
        }
        /**
         * Instanciates a new UserWipeManagedAppRegistrationsByDeviceTagParameterSetBuilder
         */
        @Nullable
        protected UserWipeManagedAppRegistrationsByDeviceTagParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public UserWipeManagedAppRegistrationsByDeviceTagParameterSet build() {
            return new UserWipeManagedAppRegistrationsByDeviceTagParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.deviceTag != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("deviceTag", deviceTag));
        }
        return result;
    }
}
