// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.WindowsArchitecture;
import com.microsoft.graph.models.WindowsMinimumOperatingSystem;
import com.microsoft.graph.models.MobileLobApp;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Windows App X.
 */
public class WindowsAppX extends MobileLobApp implements IJsonBackedObject {


    /**
     * The Applicable Architectures.
     * The Windows architecture(s) on which this app can run. Possible values are: none, x86, x64, arm, neutral; default value is none. Possible values are: none, x86, x64, arm, neutral.
     */
    @SerializedName(value = "applicableArchitectures", alternate = {"ApplicableArchitectures"})
    @Expose
	@Nullable
    public EnumSet<WindowsArchitecture> applicableArchitectures;

    /**
     * The Identity Name.
     * The identity name of the uploaded app package. For example: 'Contoso.DemoApp'.
     */
    @SerializedName(value = "identityName", alternate = {"IdentityName"})
    @Expose
	@Nullable
    public String identityName;

    /**
     * The Identity Publisher Hash.
     * The identity publisher hash of the uploaded app package. This is the hash of the publisher from the manifest. For example: 'AB82CD0XYZ'.
     */
    @SerializedName(value = "identityPublisherHash", alternate = {"IdentityPublisherHash"})
    @Expose
	@Nullable
    public String identityPublisherHash;

    /**
     * The Identity Resource Identifier.
     * The identity resource identifier of the uploaded app package. For example: 'TestResourceId'.
     */
    @SerializedName(value = "identityResourceIdentifier", alternate = {"IdentityResourceIdentifier"})
    @Expose
	@Nullable
    public String identityResourceIdentifier;

    /**
     * The Identity Version.
     * The identity version of the uploaded app package. For example: '1.0.0.0'.
     */
    @SerializedName(value = "identityVersion", alternate = {"IdentityVersion"})
    @Expose
	@Nullable
    public String identityVersion;

    /**
     * The Is Bundle.
     * When TRUE, indicates that the app is a bundle. When FALSE, indicates that the app is not a bundle. By default, property is set to FALSE.
     */
    @SerializedName(value = "isBundle", alternate = {"IsBundle"})
    @Expose
	@Nullable
    public Boolean isBundle;

    /**
     * The Minimum Supported Operating System.
     * The value for the minimum applicable operating system. Valid values for a WindowsAppX app include v8_0, v8_1 and v10_0. If the app is a bundle, the minimum supported OS has to be at least v8_1.
     */
    @SerializedName(value = "minimumSupportedOperatingSystem", alternate = {"MinimumSupportedOperatingSystem"})
    @Expose
	@Nullable
    public WindowsMinimumOperatingSystem minimumSupportedOperatingSystem;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
