// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.WorkbookFunctionResult;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Functions Match Parameter Set.
 */
public class WorkbookFunctionsMatchParameterSet {
    /**
     * The lookup Value.
     * 
     */
    @SerializedName(value = "lookupValue", alternate = {"LookupValue"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement lookupValue;

    /**
     * The lookup Array.
     * 
     */
    @SerializedName(value = "lookupArray", alternate = {"LookupArray"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement lookupArray;

    /**
     * The match Type.
     * 
     */
    @SerializedName(value = "matchType", alternate = {"MatchType"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement matchType;


    /**
     * Instiaciates a new WorkbookFunctionsMatchParameterSet
     */
    public WorkbookFunctionsMatchParameterSet() {}
    /**
     * Instiaciates a new WorkbookFunctionsMatchParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected WorkbookFunctionsMatchParameterSet(@Nonnull final WorkbookFunctionsMatchParameterSetBuilder builder) {
        this.lookupValue = builder.lookupValue;
        this.lookupArray = builder.lookupArray;
        this.matchType = builder.matchType;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static WorkbookFunctionsMatchParameterSetBuilder newBuilder() {
        return new WorkbookFunctionsMatchParameterSetBuilder();
    }
    /**
     * Fluent builder for the WorkbookFunctionsMatchParameterSet
     */
    public static final class WorkbookFunctionsMatchParameterSetBuilder {
        /**
         * The lookupValue parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement lookupValue;
        /**
         * Sets the LookupValue
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsMatchParameterSetBuilder withLookupValue(@Nullable final com.google.gson.JsonElement val) {
            this.lookupValue = val;
            return this;
        }
        /**
         * The lookupArray parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement lookupArray;
        /**
         * Sets the LookupArray
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsMatchParameterSetBuilder withLookupArray(@Nullable final com.google.gson.JsonElement val) {
            this.lookupArray = val;
            return this;
        }
        /**
         * The matchType parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement matchType;
        /**
         * Sets the MatchType
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsMatchParameterSetBuilder withMatchType(@Nullable final com.google.gson.JsonElement val) {
            this.matchType = val;
            return this;
        }
        /**
         * Instanciates a new WorkbookFunctionsMatchParameterSetBuilder
         */
        @Nullable
        protected WorkbookFunctionsMatchParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public WorkbookFunctionsMatchParameterSet build() {
            return new WorkbookFunctionsMatchParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.lookupValue != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("lookupValue", lookupValue));
        }
        if(this.lookupArray != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("lookupArray", lookupArray));
        }
        if(this.matchType != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("matchType", matchType));
        }
        return result;
    }
}
